/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.bindings;

import android.content.Context;
import android.database.Cursor;
import android.view.View;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import mobi.liason.loaders.BindDefinition;
import mobi.liason.mvvm.bindings.interfaces.Binding;
import mobi.liason.mvvm.bindings.interfaces.ColumnBinding;
import mobi.liason.mvvm.bindings.interfaces.ColumnResourceBinding;
import mobi.liason.mvvm.bindings.interfaces.DataBinding;
import mobi.liason.mvvm.bindings.interfaces.ResourceBinding;
import mobi.liason.mvvm.database.ViewModelColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemBinding
extends BindDefinition {
    private View mRootView;
    private final Set<Binding> mBindings;

    public ItemBinding(Context context, View rootView, Binding binding) {
        this(context, rootView, Sets.newHashSet((Object[])new Binding[]{binding}));
    }

    public ItemBinding(Context context, View rootView) {
        this(context, rootView, new HashSet<Binding>());
    }

    public ItemBinding(Context context) {
        this(context, null, new HashSet<Binding>());
    }

    public ItemBinding(Context context, View rootView, Set<Binding> bindings) {
        super(context);
        this.mRootView = rootView;
        this.mBindings = bindings;
        for (Binding binding : bindings) {
            this.extractResourceIds(binding);
        }
    }

    public void setRootView(View rootView) {
        this.mRootView = rootView;
    }

    public void addBinding(Binding binding) {
        this.mBindings.add(binding);
        this.extractResourceIds(binding);
    }

    private void extractResourceIds(Binding binding) {
        if (binding instanceof ResourceBinding) {
            ResourceBinding resourceBinding = (ResourceBinding)binding;
            Set<Integer> resourceIds = resourceBinding.getResourceIds();
            for (int resourceId : resourceIds) {
                View view = this.mRootView.findViewById(resourceId);
                this.mRootView.setTag(resourceId, (Object)view);
            }
        }
    }

    public void onBind(Context context, Cursor cursor) {
        ItemBinding.bind(context, this.mBindings, this.mRootView, cursor);
    }

    public static void bind(Context context, Set<Binding> bindings, View view, Cursor cursor) {
        for (Binding binding : bindings) {
            binding.onBindStart(context);
            if (binding instanceof ResourceBinding) {
                ResourceBinding resourceBinding = (ResourceBinding)binding;
                for (Integer resourceId : resourceBinding.getResourceIds()) {
                    View bindingView = (View)view.getTag(resourceId.intValue());
                    resourceBinding.onBind(context, bindingView, resourceId);
                    if (!(binding instanceof ColumnResourceBinding)) continue;
                    ColumnResourceBinding columnResourceBinding = (ColumnResourceBinding)binding;
                    for (ViewModelColumn viewModelColumn : columnResourceBinding.getViewModelColumns()) {
                        Object value = viewModelColumn.getValue(cursor);
                        columnResourceBinding.onBind(context, bindingView, resourceId, viewModelColumn, value);
                    }
                }
            }
            if (binding instanceof ColumnBinding) {
                ColumnBinding columnBinding = (ColumnBinding)binding;
                for (ViewModelColumn viewModelColumn : columnBinding.getViewModelColumns()) {
                    Object value = viewModelColumn.getValue(cursor);
                    columnBinding.onBind(context, viewModelColumn, value);
                }
            }
            if (binding instanceof DataBinding) {
                DataBinding dataBinding = (DataBinding)binding;
                dataBinding.onBind(context, cursor);
            }
            binding.onBindEnd(context);
        }
    }
}

