/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.bindings.adapters;

import android.content.Context;
import android.database.Cursor;
import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mobi.liason.loaders.BindDefinition;
import mobi.liason.mvvm.bindings.adapters.AdapterItemBinding;
import mobi.liason.mvvm.bindings.adapters.BindingCursorAdapter;
import mobi.liason.mvvm.database.ViewModelColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdapterBinding
extends BindDefinition {
    private final List<AdapterItemBinding> mAdapterItemBindings;
    private final BindingCursorAdapter mAdapter;
    private final ViewModelColumn mTypeViewModelColumn;
    private final AdapterView mAdapterView;

    public AdapterBinding(Context context, AdapterView adapterView) {
        this(context, adapterView, null, new ArrayList<AdapterItemBinding>());
    }

    public AdapterBinding(Context context, AdapterView adapterView, AdapterItemBinding adapterItemBinding) {
        this(context, adapterView, null, (List<AdapterItemBinding>)Lists.newArrayList((Object[])new AdapterItemBinding[]{adapterItemBinding}));
    }

    public AdapterBinding(Context context, AdapterView adapterView, List<AdapterItemBinding> adapterItemBindings) {
        this(context, adapterView, null, adapterItemBindings);
    }

    public AdapterBinding(Context context, View rootView, int resourceId) {
        this(context, rootView, resourceId, null, new ArrayList<AdapterItemBinding>());
    }

    public AdapterBinding(Context context, View rootView, int resourceId, AdapterItemBinding adapterItemBinding) {
        this(context, rootView, resourceId, null, Lists.newArrayList((Object[])new AdapterItemBinding[]{adapterItemBinding}));
    }

    public AdapterBinding(Context context, View rootView, int resourceId, List<AdapterItemBinding> adapterItemBindings) {
        this(context, rootView, resourceId, null, adapterItemBindings);
    }

    public AdapterBinding(Context context, View rootView, int resourceId, ViewModelColumn viewModelColumn) {
        this(context, rootView, resourceId, viewModelColumn, new ArrayList<AdapterItemBinding>());
    }

    public AdapterBinding(Context context, View rootView, int resourceId, ViewModelColumn viewModelColumn, AdapterItemBinding adapterItemBinding) {
        this(context, rootView, resourceId, viewModelColumn, Lists.newArrayList((Object[])new AdapterItemBinding[]{adapterItemBinding}));
    }

    public AdapterBinding(Context context, View rootView, int resourceId, ViewModelColumn viewModelColumn, List<AdapterItemBinding> adapterItemBindings) {
        this(context, (AdapterView)rootView.findViewById(resourceId), viewModelColumn, adapterItemBindings);
    }

    public AdapterBinding(Context context, AdapterView adapterView, ViewModelColumn viewModelColumn, List<AdapterItemBinding> adapterItemBindings) {
        super(context);
        this.mAdapter = new BindingCursorAdapter(context, this);
        this.mTypeViewModelColumn = viewModelColumn;
        this.mAdapterItemBindings = new ArrayList<AdapterItemBinding>(adapterItemBindings);
        this.mAdapterView = adapterView;
        adapterView.setAdapter((Adapter)this.mAdapter);
    }

    public void addItemBinding(AdapterItemBinding adapterItemBinding) {
        this.mAdapterItemBindings.add(adapterItemBinding);
    }

    public void setItemBindings(List<AdapterItemBinding> adapterItemBindings) {
        this.mAdapterItemBindings.clear();
        this.mAdapterItemBindings.addAll(adapterItemBindings);
    }

    public void onBind(Context context, Cursor cursor) {
        this.mAdapter.swapCursor(cursor);
    }

    public AdapterItemBinding getItemTypeBinding(int type) {
        return this.mAdapterItemBindings.get(type);
    }

    public int getItemTypeCount() {
        return Math.max(this.mAdapterItemBindings.size(), 1);
    }

    public int getItemType(Cursor cursor) {
        if (this.mTypeViewModelColumn == null) {
            return 0;
        }
        return (Integer)this.mTypeViewModelColumn.getValue(cursor);
    }
}

