/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.bindings.adapters;

import android.content.Context;
import android.database.Cursor;
import android.view.View;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import mobi.liason.mvvm.bindings.ItemBinding;
import mobi.liason.mvvm.bindings.interfaces.Binding;
import mobi.liason.mvvm.bindings.interfaces.ResourceBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterItemBinding {
    private final int mLayoutResourceId;
    private final Set<Integer> mResourceIds = new HashSet<Integer>();
    private final Set<Binding> mBindings;

    public AdapterItemBinding(int layoutResourceId) {
        this(layoutResourceId, new HashSet<Binding>());
    }

    public AdapterItemBinding(int layoutResourceId, Binding binding) {
        this(layoutResourceId, Sets.newHashSet((Object[])new Binding[]{binding}));
    }

    public AdapterItemBinding(int layoutResourceId, Set<Binding> bindings) {
        this.mLayoutResourceId = layoutResourceId;
        this.mBindings = bindings;
        for (Binding binding : bindings) {
            this.extractResourceIds(binding);
        }
    }

    private void extractResourceIds(Binding binding) {
        if (binding instanceof ResourceBinding) {
            ResourceBinding resourceBinding = (ResourceBinding)binding;
            Set<Integer> resourceIds = resourceBinding.getResourceIds();
            for (int resourceId : resourceIds) {
                this.mResourceIds.add(resourceId);
            }
        }
    }

    public void addBinding(Binding binding) {
        this.mBindings.add(binding);
        this.extractResourceIds(binding);
    }

    public int getLayoutResourceId() {
        return this.mLayoutResourceId;
    }

    public Set<Integer> getResourceIds() {
        return this.mResourceIds;
    }

    public void bind(Context context, View view, Cursor cursor) {
        ItemBinding.bind(context, this.mBindings, view, cursor);
    }
}

