/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.bindings.adapters;

import android.content.Context;
import android.database.Cursor;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import java.util.Set;
import mobi.liason.mvvm.bindings.adapters.AdapterBinding;
import mobi.liason.mvvm.bindings.adapters.AdapterItemBinding;

public class BindingCursorAdapter
extends CursorAdapter {
    private final Context mContext;
    private final AdapterBinding mAdapterBinding;

    public BindingCursorAdapter(Context context, AdapterBinding adapterBinding) {
        this(context, null, adapterBinding, false);
    }

    public BindingCursorAdapter(Context context, AdapterBinding adapterBinding, boolean autoRequery) {
        this(context, null, null, autoRequery);
    }

    public BindingCursorAdapter(Context context, AdapterBinding adapterBinding, int flags) {
        this(context, null, null, flags);
    }

    public BindingCursorAdapter(Context context, Cursor cursor, AdapterBinding adapterBinding) {
        this(context, cursor, adapterBinding, false);
    }

    public BindingCursorAdapter(Context context, Cursor cursor, AdapterBinding adapterBinding, boolean autoRequery) {
        super(context, cursor, autoRequery);
        this.mContext = context;
        this.mAdapterBinding = adapterBinding;
    }

    public BindingCursorAdapter(Context context, Cursor cursor, AdapterBinding adapterBinding, int flags) {
        super(context, cursor, flags);
        this.mContext = context;
        this.mAdapterBinding = adapterBinding;
    }

    private static void optimize(View view, int resourceId) {
        view.setTag(resourceId, (Object)view.findViewById(resourceId));
    }

    private AdapterItemBinding getItemTypeBinding(Cursor cursor) {
        int type = this.getItemViewType(cursor);
        return this.mAdapterBinding.getItemTypeBinding(type);
    }

    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        AdapterItemBinding adapterItemBinding = this.getItemTypeBinding(cursor);
        int layoutResourceId = adapterItemBinding.getLayoutResourceId();
        View rootView = layoutInflater.inflate(layoutResourceId, parent, false);
        Set<Integer> resourceIds = adapterItemBinding.getResourceIds();
        for (Integer resourceId : resourceIds) {
            BindingCursorAdapter.optimize(rootView, resourceId);
        }
        return rootView;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Cursor cursor = (Cursor)this.getItem(position);
        View view = this.getView(convertView, parent, cursor);
        this.bindView(view, this.mContext, cursor);
        return view;
    }

    private View getView(View convertView, ViewGroup parent, Cursor cursor) {
        if (convertView == null) {
            return this.newView(this.mContext, cursor, parent);
        }
        return convertView;
    }

    public int getViewTypeCount() {
        return this.mAdapterBinding.getItemTypeCount();
    }

    private int getItemViewType(Cursor cursor) {
        return this.mAdapterBinding.getItemType(cursor);
    }

    public int getItemViewType(int position) {
        Cursor cursor = (Cursor)this.getItem(position);
        return this.getItemViewType(cursor);
    }

    public void bindView(View view, Context context, Cursor cursor) {
        AdapterItemBinding adapterItemBinding = this.getItemTypeBinding(cursor);
        adapterItemBinding.bind(context, view, cursor);
    }
}

