/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.database;

import android.database.Cursor;

public class Column {
    private final String mName;
    private final Type mType;
    private final String mStringType;
    private final String mSqlName;

    public Column(String sqlName, String name, Type type, String stringType) {
        this.mSqlName = sqlName;
        this.mName = name;
        this.mType = type;
        this.mStringType = stringType;
    }

    public Column(String tableName, String name, Type type) {
        this.mSqlName = tableName;
        this.mName = name;
        this.mType = type;
        this.mStringType = Type.getSqlType(type);
    }

    public String getName() {
        return this.mName;
    }

    public Type getType() {
        return this.mType;
    }

    public String getStringType() {
        return this.mStringType;
    }

    public String getColumnLine() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mName);
        stringBuilder.append(' ');
        stringBuilder.append(this.mStringType);
        return stringBuilder.toString();
    }

    public Object getValue(Cursor cursor) {
        if (cursor.getCount() == 0) {
            return null;
        }
        int columnIndex = cursor.getColumnIndex(this.mName);
        if (columnIndex == -1 || cursor.isNull(columnIndex)) {
            return null;
        }
        switch (this.mType) {
            case blob: {
                return cursor.getBlob(columnIndex);
            }
            case integer: {
                return cursor.getLong(columnIndex);
            }
            case real: {
                return Float.valueOf(cursor.getFloat(columnIndex));
            }
        }
        return cursor.getString(columnIndex);
    }

    public String getSqlName() {
        return this.mSqlName;
    }

    public String toString() {
        return this.mName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        text,
        integer,
        blob,
        real;


        public static String getSqlType(Type type) {
            switch (type) {
                case blob: {
                    return "BLOB";
                }
                case integer: {
                    return "INTEGER";
                }
                case real: {
                    return "REAL";
                }
            }
            return "TEXT";
        }
    }
}

