/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.database;

import android.content.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mobi.liason.loaders.Content;
import mobi.liason.loaders.Path;
import mobi.liason.mvvm.database.Column;
import mobi.liason.mvvm.database.annotations.ColumnDefinition;
import mobi.liason.mvvm.database.annotations.ColumnDefinitions;
import mobi.liason.mvvm.database.annotations.PathDefinition;
import mobi.liason.mvvm.database.annotations.PathDefinitions;
import mobi.liason.mvvm.database.annotations.PrimaryKey;
import mobi.liason.mvvm.database.annotations.Unique;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model
extends Content {
    private static final String CREATE = "CREATE TABLE IF NOT EXISTS %s ( %s );";
    private static final String DROP = "DROP TABLE IF EXISTS %s;";
    private static final int VERSION = -1;
    private static final String UNIQUE = ", UNIQUE ( %s ) ON CONFLICT REPLACE";
    private static final String PRIMARY_KEYS = ", PRIMARY KEY ( %s )";
    private final List<Column> mColumns = new ArrayList<Column>();
    private final Set<Column> mUniqueColumns = new HashSet<Column>();
    private final List<Path> mPaths = new ArrayList<Path>();
    private final Set<Column> mPrimaryKeys = new HashSet<Column>();

    public Model() {
        this.initializeAnnotations();
    }

    public void initializeAnnotations() {
        Class<?> klass = ((Object)((Object)this)).getClass();
        this.initializeAnnotations(klass);
    }

    public void initializeAnnotations(Class klass) {
        Class<?>[] declaredClasses;
        Class columnClass = klass;
        for (Class<?> declaredClass : declaredClasses = columnClass.getDeclaredClasses()) {
            Annotation[] declaredClassAnnotations;
            for (Annotation declaredClassAnnotation : declaredClassAnnotations = declaredClass.getDeclaredAnnotations()) {
                if (declaredClassAnnotation instanceof ColumnDefinitions) {
                    this.initializeColumnDefinitions(declaredClass);
                    continue;
                }
                if (!(declaredClassAnnotation instanceof PathDefinitions)) continue;
                this.initializePathDefinitions(declaredClass);
            }
        }
    }

    public void initializePathDefinitions(Class<?> declaredClass) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = declaredClass.getDeclaredFields()) {
            Annotation[] declaredFieldAnnotations;
            for (Annotation declaredFieldAnnotation : declaredFieldAnnotations = declaredField.getDeclaredAnnotations()) {
                if (!(declaredFieldAnnotation instanceof PathDefinition)) continue;
                try {
                    Path path = (Path)declaredField.get(null);
                    this.mPaths.add(path);
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
    }

    public void initializeColumnDefinitions(Class<?> declaredClass) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = declaredClass.getDeclaredFields()) {
            Annotation[] declaredFieldAnnotations;
            for (Annotation declaredFieldAnnotation : declaredFieldAnnotations = declaredField.getDeclaredAnnotations()) {
                Column column;
                if (declaredFieldAnnotation instanceof PrimaryKey) {
                    try {
                        column = (Column)declaredField.get(null);
                        this.mPrimaryKeys.add(column);
                    }
                    catch (IllegalAccessException e) {}
                    continue;
                }
                if (declaredFieldAnnotation instanceof ColumnDefinition) {
                    try {
                        column = (Column)declaredField.get(null);
                        this.mColumns.add(column);
                    }
                    catch (IllegalAccessException e) {}
                    continue;
                }
                if (!(declaredFieldAnnotation instanceof Unique)) continue;
                try {
                    column = (Column)declaredField.get(null);
                    this.mUniqueColumns.add(column);
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
    }

    public String getCreate(Context context) {
        String name = this.getName(context);
        List<Column> columns = this.getColumns(context);
        Set<Column> uniqueColumns = this.getUniqueColumns(context);
        Set<Column> primaryKeyColumns = this.getPrimaryKeyColumns(context);
        String createColumns = Model.createColumns(columns, uniqueColumns, primaryKeyColumns);
        String create = String.format(CREATE, name, createColumns);
        return create;
    }

    public String getDrop(Context context) {
        String name = this.getName(context);
        String drop = String.format(DROP, name);
        return drop;
    }

    public Set<Column> getUniqueColumns(Context context) {
        return this.mUniqueColumns;
    }

    public int getVersion(Context context) {
        return -1;
    }

    public List<Column> getColumns(Context context) {
        return this.mColumns;
    }

    public static String createColumns(List<Column> columns, Set<Column> uniqueColumns, Set<Column> primaryKeyColumns) {
        StringBuilder stringBuilder = new StringBuilder();
        int size = columns.size();
        for (int index = 0; index < size; ++index) {
            Column modelColumn = columns.get(index);
            String columnName = modelColumn.getName();
            Column.Type type = modelColumn.getType();
            String typeString = Column.Type.getSqlType(type);
            stringBuilder.append(columnName);
            stringBuilder.append(' ');
            stringBuilder.append(typeString);
            if (index == size - 1) continue;
            stringBuilder.append(", ");
        }
        String uniqueLine = Model.getUniqueLine(uniqueColumns);
        stringBuilder.append(uniqueLine);
        String primaryKeyLine = Model.getPrimaryKeyLine(primaryKeyColumns);
        stringBuilder.append(primaryKeyLine);
        return stringBuilder.toString();
    }

    private static String getUniqueLine(Set<Column> uniqueColumns) {
        if (uniqueColumns == null || uniqueColumns.isEmpty()) {
            return "";
        }
        return String.format(UNIQUE, Model.getCommaSeparatedColumns(uniqueColumns));
    }

    private static String getPrimaryKeyLine(Set<Column> primaryKeyColumns) {
        if (primaryKeyColumns == null || primaryKeyColumns.isEmpty()) {
            return "";
        }
        return String.format(PRIMARY_KEYS, Model.getCommaSeparatedColumns(primaryKeyColumns));
    }

    private static String getCommaSeparatedColumns(Set<Column> columns) {
        StringBuilder stringBuilder = new StringBuilder();
        int size = columns.size();
        int index = 0;
        for (Column modelColumn : columns) {
            String columnName = modelColumn.getName();
            stringBuilder.append(columnName);
            if (index != size - 1) {
                stringBuilder.append(", ");
            }
            ++index;
        }
        return stringBuilder.toString();
    }

    public List<Path> getPaths(Context context) {
        return this.mPaths;
    }

    public Set<Column> getPrimaryKeyColumns(Context context) {
        return this.mPrimaryKeys;
    }
}

