/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.database;

import android.content.Context;
import java.util.List;
import mobi.liason.mvvm.database.Column;
import mobi.liason.mvvm.database.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewModel
extends Model {
    private static final String CREATE = "CREATE VIEW IF NOT EXISTS %s AS SELECT %s FROM %s;";
    private static final String DROP = "DROP VIEW IF EXISTS %s;";
    private static final int VERSION = -1;

    @Override
    public String getCreate(Context context) {
        String name = this.getName(context);
        List<Column> columns = this.getColumns(context);
        String createColumns = ViewModel.createColumns(columns);
        String selection = this.getSelection(context);
        String create = String.format(CREATE, name, createColumns, selection);
        return create;
    }

    @Override
    public String getDrop(Context context) {
        String name = this.getName(context);
        String drop = String.format(DROP, name);
        return drop;
    }

    @Override
    public int getVersion(Context context) {
        return -1;
    }

    protected abstract String getSelection(Context var1);

    public static String createColumns(List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            return "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int size = columns.size();
        for (int index = 0; index < size; ++index) {
            Column modelColumn = columns.get(index);
            String columnName = modelColumn.getColumnLine();
            stringBuilder.append(columnName);
            if (index == size - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }
}

