/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.database;

import mobi.liason.mvvm.database.Column;

public class ViewModelColumn
extends Column {
    private final Column mColumn;
    private final String mCustomSelection;

    public ViewModelColumn(String viewName, String name, Column.Type type, String stringType) {
        super(viewName, name, type, stringType);
        this.mColumn = null;
        this.mCustomSelection = null;
    }

    public ViewModelColumn(String viewName, String name, Column.Type type) {
        super(viewName, name, type);
        this.mColumn = null;
        this.mCustomSelection = null;
    }

    public ViewModelColumn(String viewName, String name, Column column) {
        super(viewName, name, column.getType());
        this.mColumn = column;
        this.mCustomSelection = null;
    }

    public ViewModelColumn(String viewName, Column column) {
        super(viewName, column.getName(), column.getType());
        this.mColumn = column;
        this.mCustomSelection = null;
    }

    public ViewModelColumn(String viewName, String name, String customSelection, Column.Type type) {
        super(viewName, name, type);
        this.mColumn = null;
        this.mCustomSelection = customSelection;
    }

    public String getColumnLine() {
        if (this.mColumn != null) {
            String modelTableName = this.mColumn.getSqlName();
            String modelColumnName = this.mColumn.getName();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(modelTableName);
            stringBuilder.append('.');
            stringBuilder.append(modelColumnName);
            String source = stringBuilder.toString();
            return this.getColumnLine(source);
        }
        if (this.mCustomSelection != null) {
            return this.getColumnLine(this.mCustomSelection);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String name = this.getName();
        stringBuilder.append(name);
        return stringBuilder.toString();
    }

    private String getColumnLine(String source) {
        String name = this.getName();
        StringBuilder stringBuilder = new StringBuilder(source);
        stringBuilder.append(" AS ");
        stringBuilder.append(name);
        return stringBuilder.toString();
    }
}

