/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.task;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.List;
import mobi.liason.loaders.Path;
import mobi.liason.loaders.UriUtilities;
import mobi.liason.mvvm.task.TaskState;
import mobi.liason.mvvm.task.TaskStateTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task
implements Runnable {
    private static final long STALE_DATA_THRESHOLD = 30000L;
    private final Context mContext;
    private final Uri mUri;
    private final String mAuthority;
    private JsonObject mJsonObject;
    private boolean mHasFailed;
    private boolean mForceTask;

    public Task(Context context, String authority, Uri uri) {
        this.mContext = context;
        this.mUri = uri;
        this.mAuthority = authority;
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void run() {
        boolean shouldRunRequest = this.shouldRunRequest();
        if (!shouldRunRequest) {
            return;
        }
        boolean isRunning = this.setRunning();
        if (!isRunning) {
            return;
        }
        this.notifyTaskState();
        try {
            this.onPreExecuteTask(this.mContext);
            this.onExecuteTask(this.mContext);
            this.onPostExecuteTask(this.mContext);
        }
        catch (Exception exception) {
            this.setFailure(true);
        }
        this.onComplete();
        this.notifyTaskState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRunRequest() {
        String uriString = this.mUri.toString();
        Path path = TaskStateTable.Paths.TASK_STATE;
        Uri taskStateUri = UriUtilities.getUri((String)"content", (String)this.mAuthority, (Path)path, (Object[])new Object[]{uriString});
        ContentResolver contentResolver = this.mContext.getContentResolver();
        Cursor cursor = null;
        try {
            boolean forceTask = this.forceTask();
            if (forceTask) {
                boolean bl = true;
                return bl;
            }
            cursor = contentResolver.query(taskStateUri, null, null, null, null);
            boolean bl = this.needsUpdate(cursor);
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void setFailure(boolean hasFailed) {
        this.mHasFailed = hasFailed;
    }

    private void onComplete() {
        if (this.mHasFailed) {
            this.onFailure();
        } else {
            this.onSuccess();
        }
    }

    public void setJsonObject(JsonObject jsonObject) {
        this.mJsonObject = jsonObject;
    }

    private void onFailure() {
        this.setState("fail");
    }

    private void onSuccess() {
        this.setState("success");
    }

    private void setState(String state) {
        String uriString = this.mUri.toString();
        Path path = TaskStateTable.Paths.TASK_STATE;
        Uri taskStateUri = UriUtilities.getUri((String)"content", (String)this.mAuthority, (Path)path, (Object[])new Object[]{uriString});
        String selection = TaskStateTable.Columns.URI.getName() + "=?";
        String[] selectionArguments = new String[]{uriString};
        long time = System.currentTimeMillis();
        TaskState taskState = new TaskState(uriString, state, time, this.mJsonObject);
        ContentValues contentValues = TaskStateTable.getContentValues(taskState);
        ContentResolver contentResolver = this.mContext.getContentResolver();
        contentResolver.update(taskStateUri, contentValues, selection, selectionArguments);
    }

    private boolean setRunning() {
        String uriString = this.mUri.toString();
        Path path = TaskStateTable.Paths.TASK_STATE;
        Uri taskStateUri = UriUtilities.getUri((String)"content", (String)this.mAuthority, (Path)path, (Object[])new Object[]{uriString});
        long time = System.currentTimeMillis();
        TaskState taskState = new TaskState(uriString, "running", time, null);
        ContentValues contentValues = TaskStateTable.getContentValues(taskState);
        ContentResolver contentResolver = this.mContext.getContentResolver();
        Uri uri = contentResolver.insert(taskStateUri, contentValues);
        return uri != null;
    }

    private boolean forceTask() {
        return this.mForceTask;
    }

    void setForceTask(boolean forceTask) {
        this.mForceTask = forceTask;
    }

    public boolean needsUpdate(Cursor cursor) {
        if (cursor.moveToFirst()) {
            long expirationTime;
            int timeColumnIndex = cursor.getColumnIndex(TaskStateTable.Columns.TIME.getName());
            long time = cursor.getLong(timeColumnIndex);
            long duration = Math.abs(System.currentTimeMillis() - time);
            return duration > (expirationTime = this.getUpdateTime());
        }
        return true;
    }

    public long getUpdateTime() {
        return 30000L;
    }

    private void notifyTaskState() {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        List<Uri> taskUris = this.getTaskUris();
        for (Uri uri : taskUris) {
            contentResolver.notifyChange(uri, null, false);
        }
    }

    public List<Uri> getTaskUris() {
        return Lists.newArrayList((Object[])new Uri[]{this.mUri});
    }

    protected void onPreExecuteTask(Context context) throws Exception {
    }

    protected void onPostExecuteTask(Context context) throws Exception {
    }

    protected abstract void onExecuteTask(Context var1) throws Exception;

    public Uri getUri() {
        return this.mUri;
    }
}

