/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.task;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.net.Uri;
import android.os.IBinder;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import mobi.liason.loaders.Path;
import mobi.liason.mvvm.database.annotations.PathDefinition;
import mobi.liason.mvvm.database.annotations.PathDefinitions;
import mobi.liason.mvvm.task.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskService
extends Service {
    private static final int THREAD_POOL_SIZE = 4;
    private static final ScheduledThreadPoolExecutor mSheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(4);
    private final UriMatcher mURIMatcher = new UriMatcher(-1);
    public static final Map<Integer, Class> mCodeTaskClassMap = new HashMap<Integer, Class>();

    public abstract String getAuthority(Context var1);

    public abstract Set<Class> getTasks(Context var1);

    public void onCreate() {
        Context context = this.getApplicationContext();
        String authority = this.getAuthority(context);
        int index = 0;
        Set<Class> tasks = this.getTasks(context);
        for (Class klass : tasks) {
            Set<Path> paths = TaskService.getPaths(klass);
            for (Path path : paths) {
                String matcherPath = path.getMatcherPath();
                this.mURIMatcher.addURI(authority, matcherPath, index);
                mCodeTaskClassMap.put(index, klass);
                ++index;
            }
        }
        super.onCreate();
    }

    private Set<Path> getPaths(Context context, Task task) {
        return TaskService.getPaths(task.getClass());
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.handleOnStart(intent);
        return super.onStartCommand(intent, flags, startId);
    }

    private void handleOnStart(Intent intent) {
        if (intent == null) {
            return;
        }
        String uriString = intent.getStringExtra("uri");
        boolean forceTask = intent.getBooleanExtra("forceTask", false);
        Uri uri = Uri.parse((String)uriString);
        int code = this.mURIMatcher.match(uri);
        Context context = this.getApplicationContext();
        String authority = this.getAuthority(context);
        Task task = TaskService.getTask(context, authority, uri, code);
        task.setForceTask(forceTask);
        this.runTask(task);
    }

    public void runTask(Task task) {
        if (task == null) {
            return;
        }
        mSheduledThreadPoolExecutor.execute(task);
    }

    private static Task getTask(Context context, String authority, Uri uri, int code) {
        Class klass = mCodeTaskClassMap.get(code);
        return TaskService.createTask(context, authority, uri, klass);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public static <T extends Task> T createTask(Context context, String authority, Uri uri, Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(Context.class, String.class, Uri.class);
            constructor.setAccessible(true);
            return (T)((Task)constructor.newInstance(context, authority, uri));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void startTask(Context context, Uri uri, Class klass) {
        String uriString = uri.toString();
        Intent intent = new Intent(context, klass);
        intent.putExtra("uri", uriString);
        context.startService(intent);
    }

    public static void forceStartTask(Context context, Uri uri, Class klass) {
        String uriString = uri.toString();
        Intent intent = new Intent(context, klass);
        intent.putExtra("uri", uriString);
        intent.putExtra("forceTask", true);
        context.startService(intent);
    }

    public static Set<Path> getPaths(Class klass) {
        Class<?>[] declaredClasses;
        Class columnClass = klass;
        for (Class<?> declaredClass : declaredClasses = columnClass.getDeclaredClasses()) {
            Annotation[] declaredClassAnnotations;
            for (Annotation declaredClassAnnotation : declaredClassAnnotations = declaredClass.getDeclaredAnnotations()) {
                if (!(declaredClassAnnotation instanceof PathDefinitions)) continue;
                return TaskService.getPathDefinitions(declaredClass);
            }
        }
        return Sets.newHashSet();
    }

    public static Set<Path> getPathDefinitions(Class<?> declaredClass) {
        Field[] declaredFields;
        HashSet<Path> paths = new HashSet<Path>();
        for (Field declaredField : declaredFields = declaredClass.getDeclaredFields()) {
            Annotation[] declaredFieldAnnotations;
            for (Annotation declaredFieldAnnotation : declaredFieldAnnotations = declaredField.getDeclaredAnnotations()) {
                if (!(declaredFieldAnnotation instanceof PathDefinition)) continue;
                try {
                    Path path = (Path)declaredField.get(null);
                    paths.add(path);
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        return paths;
    }

    protected static final class EXTRAS {
        public static final String URI = "uri";
        public static final String FORCE_TASK = "forceTask";

        protected EXTRAS() {
        }
    }
}

