/*
 * Decompiled with CFR 0.152.
 */
package mobi.liason.mvvm.task;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import mobi.liason.loaders.Path;
import mobi.liason.loaders.UriUtilities;
import mobi.liason.mvvm.database.Column;
import mobi.liason.mvvm.database.Model;
import mobi.liason.mvvm.database.ModelColumn;
import mobi.liason.mvvm.database.annotations.ColumnDefinition;
import mobi.liason.mvvm.database.annotations.ColumnDefinitions;
import mobi.liason.mvvm.database.annotations.PathDefinition;
import mobi.liason.mvvm.database.annotations.PathDefinitions;
import mobi.liason.mvvm.task.TaskState;

public class TaskStateTable
extends Model {
    public static final String TABLE_NAME = "TasksStateTable";

    public static ContentValues getContentValues(TaskState taskState) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(Columns.URI.getName(), taskState.getUri());
        contentValues.put(Columns.STATE.getName(), taskState.getState());
        contentValues.put(Columns.TIME.getName(), taskState.getTime());
        byte[] jsonObjectByteArray = taskState.getJsonByteArray();
        if (jsonObjectByteArray != null) {
            contentValues.put(Columns.JSON.getName(), jsonObjectByteArray);
        }
        return contentValues;
    }

    public String getName(Context context) {
        return TABLE_NAME;
    }

    public Cursor query(Context context, SQLiteDatabase sqLiteDatabase, Path path, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String uriString = uri.getLastPathSegment();
        String[] overridenProjection = new String[]{Columns.TIME.getName()};
        String overridenSelection = Columns.URI.getName() + "=?";
        String[] overridenSelectionArguments = new String[]{uriString};
        return super.query(context, sqLiteDatabase, path, uri, overridenProjection, overridenSelection, overridenSelectionArguments, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(Context context, SQLiteDatabase sqLiteDatabase, Path path, Uri uri, ContentValues contentValues) {
        String uriString = uri.getLastPathSegment();
        sqLiteDatabase.beginTransaction();
        try {
            String selection = Columns.URI.getName() + "=? AND " + Columns.STATE.getName() + "<>?";
            String[] selectionArguments = new String[]{uriString, "running"};
            int rows = sqLiteDatabase.update(TABLE_NAME, contentValues, selection, selectionArguments);
            if (rows == 0) {
                String queryWhereClause = Columns.URI.getName() + "=? AND " + Columns.STATE.getName() + "=?";
                String[] queryWhereArguments = new String[]{uriString, "running"};
                Cursor cursor = sqLiteDatabase.query(TABLE_NAME, null, queryWhereClause, queryWhereArguments, null, null, null);
                try {
                    if (cursor.getCount() != 0) {
                        Uri uri2 = null;
                        return uri2;
                    }
                }
                finally {
                    cursor.close();
                }
                sqLiteDatabase.insert(TABLE_NAME, null, contentValues);
            }
            sqLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sqLiteDatabase.endTransaction();
        }
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        return UriUtilities.getUri((String)scheme, (String)authority, (Path)Paths.TASK_STATE, (Object[])new Object[]{uriString});
    }

    @PathDefinitions
    public static class Paths {
        @PathDefinition
        public static final Path TASK_STATE = new Path(new String[]{"TasksStateTable", "*"});
    }

    @ColumnDefinitions
    public static class Columns {
        @ColumnDefinition
        public static final ModelColumn URI = new ModelColumn("TasksStateTable", "uri", Column.Type.text);
        @ColumnDefinition
        public static final ModelColumn STATE = new ModelColumn("TasksStateTable", "state", Column.Type.text);
        @ColumnDefinition
        public static final ModelColumn TIME = new ModelColumn("TasksStateTable", "time", Column.Type.integer);
        @ColumnDefinition
        public static final ModelColumn JSON = new ModelColumn("TasksStateTable", "json", Column.Type.blob);
    }

    public static final class State {
        public static final String RUNNING = "running";
        public static final String SUCCESS = "success";
        public static final String FAIL = "fail";
    }
}

