/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import mockit.coverage.CoverageData;

final class AccretionFile {
    private final File dataFile;

    AccretionFile(String outputDir) {
        String parentDir = outputDir.length() == 0 ? null : outputDir;
        this.dataFile = new File(parentDir, "coverage.ser");
    }

    void generate(CoverageData newData) throws ClassNotFoundException, IOException {
        newData.fillLastModifiedTimesForAllClassFiles();
        if (this.dataFile.exists()) {
            CoverageData previousData = CoverageData.readDataFromFile(this.dataFile);
            newData.merge(previousData);
        }
        newData.writeDataToFile(this.dataFile);
        System.out.println("JMockit: Coverage data written to " + this.dataFile.getCanonicalPath());
    }
}

