/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mockit.coverage.CallPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BranchCoverageData
implements Serializable {
    private static final long serialVersionUID = 1003335601845442606L;
    private boolean unreachable;
    private final int jumpInsnIndex;
    private int jumpTargetInsnIndex = -1;
    private int noJumpTargetInsnIndex = -1;
    private List<CallPoint> jumpCallPoints;
    private List<CallPoint> noJumpCallPoints;
    private int jumpExecutionCount;
    private int noJumpExecutionCount;

    BranchCoverageData(int jumpInsnIndex) {
        this.jumpInsnIndex = jumpInsnIndex;
    }

    void setJumpTargetInsnIndex(int jumpTargetInsnIndex) {
        this.jumpTargetInsnIndex = jumpTargetInsnIndex;
    }

    void setNoJumpTargetInsnIndex(int noJumpTargetInsnIndex) {
        this.noJumpTargetInsnIndex = noJumpTargetInsnIndex;
    }

    void registerJumpExecution(CallPoint callPoint) {
        ++this.jumpExecutionCount;
        if (callPoint != null) {
            if (this.jumpCallPoints == null) {
                this.jumpCallPoints = new ArrayList<CallPoint>();
            }
            this.jumpCallPoints.add(callPoint);
        }
    }

    void registerNoJumpExecution(CallPoint callPoint) {
        ++this.noJumpExecutionCount;
        if (callPoint != null) {
            if (this.noJumpCallPoints == null) {
                this.noJumpCallPoints = new ArrayList<CallPoint>();
            }
            this.noJumpCallPoints.add(callPoint);
        }
    }

    public int getJumpInsnIndex() {
        return this.jumpInsnIndex;
    }

    public int getJumpTargetInsnIndex() {
        return this.jumpTargetInsnIndex;
    }

    public int getNoJumpTargetInsnIndex() {
        return this.noJumpTargetInsnIndex;
    }

    public int getJumpExecutionCount() {
        return this.jumpExecutionCount;
    }

    public int getNoJumpExecutionCount() {
        return this.noJumpExecutionCount;
    }

    public List<CallPoint> getJumpCallPoints() {
        return this.jumpCallPoints == null ? Collections.emptyList() : Collections.unmodifiableList(this.jumpCallPoints);
    }

    public List<CallPoint> getNoJumpCallPoints() {
        return this.noJumpCallPoints == null ? Collections.emptyList() : Collections.unmodifiableList(this.noJumpCallPoints);
    }

    public boolean isCovered() {
        return this.unreachable || (this.jumpTargetInsnIndex < 0 || this.jumpExecutionCount > 0) && (this.noJumpTargetInsnIndex < 0 || this.noJumpExecutionCount > 0);
    }

    public void markAsUnreachable() {
        this.unreachable = true;
    }

    void addCountsFromPreviousMeasurement(BranchCoverageData previousData) {
        this.jumpExecutionCount += previousData.jumpExecutionCount;
        this.jumpCallPoints = this.addPreviousCallPoints(this.jumpCallPoints, previousData.jumpCallPoints);
        this.noJumpExecutionCount += previousData.noJumpExecutionCount;
        this.noJumpCallPoints = this.addPreviousCallPoints(this.noJumpCallPoints, previousData.noJumpCallPoints);
    }

    private List<CallPoint> addPreviousCallPoints(List<CallPoint> current, List<CallPoint> previous) {
        if (previous != null) {
            if (current != null) {
                current.addAll(0, previous);
            } else {
                return previous;
            }
        }
        return current;
    }
}

