/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.UnmodifiableClassException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import mockit.coverage.CoverageData;
import mockit.coverage.CoverageModifier;
import mockit.coverage.OutputFileGenerator;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import org.objectweb.asm2.ClassReader;
import org.objectweb.asm2.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeCoverage
implements ClassFileTransformer {
    private static final String[] NO_ARGS = new String[0];
    private final Set<String> modifiedClasses = new HashSet<String>();
    private final Pattern classNameRegex;

    public CodeCoverage(String argsSeparatedByColon) {
        String[] args = argsSeparatedByColon == null ? NO_ARGS : argsSeparatedByColon.split(":");
        this.classNameRegex = this.getClassNameRegex(args);
        this.redefineClassesAlreadyLoadedForCoverage();
        this.setUpOutputFileGenerators(args);
    }

    private Pattern getClassNameRegex(String[] args) {
        return args.length == 0 || args[0].length() == 0 ? null : Pattern.compile(args[0]);
    }

    private void setUpOutputFileGenerators(String[] args) {
        String[] sourceDirs;
        String outputDir;
        int argCount = args.length;
        String outputFormat = argCount <= 1 ? "" : args[1];
        OutputFileGenerator outputFileGenerator = new OutputFileGenerator(outputFormat, outputDir = argCount <= 2 ? "" : args[2], sourceDirs = argCount <= 3 ? NO_ARGS : args[3].split(","));
        if (outputFileGenerator.isOutputToBeGenerated()) {
            CoverageData.instance().setWithCallPoints(outputFileGenerator.isWithCallPoints());
            Runtime.getRuntime().addShutdownHook(outputFileGenerator);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String internalClassName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] originalClassfile) {
        if (classBeingRedefined != null) {
            return originalClassfile;
        }
        String className = internalClassName.replace('/', '.');
        boolean modifyClassForCoverage = this.isToBeConsideredForCoverage(className, protectionDomain);
        if (modifyClassForCoverage) {
            byte[] modifiedClassfile = this.readAndModifyClassForCoverage(originalClassfile);
            this.registerClassAsModifiedForCoverage(className, modifiedClassfile);
            return modifiedClassfile;
        }
        return originalClassfile;
    }

    private boolean isToBeConsideredForCoverage(String className, ProtectionDomain protectionDomain) {
        if (this.modifiedClasses.contains(className)) {
            return false;
        }
        int p = className.lastIndexOf(36);
        if (className.endsWith("Test") || p > 0 && className.substring(0, p).endsWith("Test")) {
            return false;
        }
        if (this.classNameRegex != null) {
            return this.classNameRegex.matcher(className).matches();
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        return codeSource != null && !codeSource.getLocation().getPath().endsWith(".jar") && !className.startsWith("mockit.");
    }

    private void registerClassAsModifiedForCoverage(String className, byte[] modifiedClassfile) {
        this.modifiedClasses.add(className);
        TestRun.mockFixture().addFixedClass(className, modifiedClassfile);
    }

    private void redefineClassesAlreadyLoadedForCoverage() {
        Class[] loadedClasses;
        for (Class loadedClass : loadedClasses = Startup.instrumentation().getInitiatedClasses(CodeCoverage.class.getClassLoader())) {
            if (loadedClass.isAnnotation() || loadedClass.isSynthetic() || !this.isToBeConsideredForCoverage(loadedClass.getName(), loadedClass.getProtectionDomain())) continue;
            this.redefineClassForCoverage(loadedClass);
        }
    }

    private void redefineClassForCoverage(Class<?> loadedClass) {
        String className = loadedClass.getName();
        byte[] modifiedClassfile = this.readAndRedefineClassForCoverage(loadedClass);
        if (modifiedClassfile != null) {
            this.registerClassAsModifiedForCoverage(className, modifiedClassfile);
        }
    }

    private byte[] readAndRedefineClassForCoverage(Class<?> loadedClass) {
        try {
            ClassReader cr = new ClassReader(loadedClass.getName());
            CoverageModifier modifier = new CoverageModifier(cr);
            cr.accept((ClassVisitor)modifier, false);
            byte[] modifiedClassfile = modifier.toByteArray();
            ClassDefinition[] classDefs = new ClassDefinition[]{new ClassDefinition(loadedClass, modifiedClassfile)};
            Startup.instrumentation().redefineClasses(classDefs);
            return modifiedClassfile;
        }
        catch (IOException ignore) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] readAndModifyClassForCoverage(byte[] classfileBuffer) {
        ClassReader cr = new ClassReader(classfileBuffer);
        CoverageModifier modifier = new CoverageModifier(cr);
        cr.accept((ClassVisitor)modifier, false);
        return modifier.toByteArray();
    }
}

