/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mockit.coverage.CallPoint;
import mockit.coverage.FileCoverageData;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageData
implements Serializable {
    private static final long serialVersionUID = -4860004226098360259L;
    private static final CoverageData instance;
    private static final ThreadLocal<Boolean> executingCoverageCall;
    private static final Map<StackTraceElement, Boolean> steCache;
    private static final Class<? extends Annotation> testAnnotation;
    private static final boolean checkTestAnnotationOnClass;
    private static final boolean checkIfTestCaseSubclass;
    private boolean withCallPoints;
    private final Map<String, FileCoverageData> fileToFileData = new ConcurrentHashMap<String, FileCoverageData>();

    private static Class<?> getTestNGAnnotationIfAvailable() {
        try {
            return Class.forName("org.testng.annotations.Test");
        }
        catch (ClassNotFoundException ignore) {
            try {
                return Class.forName("org.testng.Test");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean checkForJUnit3Availability() {
        try {
            Class.forName("junit.framework.TestCase");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public static CoverageData instance() {
        return instance;
    }

    public void setWithCallPoints(boolean withCallPoints) {
        this.withCallPoints = withCallPoints;
    }

    public Map<String, FileCoverageData> getFileToFileDataMap() {
        return Collections.unmodifiableMap(this.fileToFileData);
    }

    FileCoverageData addFile(String file) {
        FileCoverageData fileData = this.getFileData(file);
        if (fileData == null) {
            fileData = new FileCoverageData();
            this.fileToFileData.put(file, fileData);
        }
        return fileData;
    }

    private FileCoverageData getFileData(String file) {
        return this.fileToFileData.get(file);
    }

    public static void lineExecuted(String file, int line) {
        if (executingCoverageCall.get().booleanValue()) {
            return;
        }
        executingCoverageCall.set(true);
        CallPoint callPoint = CoverageData.instance.withCallPoints ? CoverageData.findCallPoint(file, line, new Throwable()) : null;
        FileCoverageData fileData = instance.getFileData(file);
        fileData.incrementLineCount(line, callPoint);
        executingCoverageCall.set(false);
    }

    private static CallPoint findCallPoint(String file, int line, Throwable newThrowable) {
        StackTraceElement[] stackTrace = newThrowable.getStackTrace();
        StackTraceElement ste = stackTrace[1];
        assert (file.endsWith(ste.getFileName())) : "Found file " + ste.getFileName() + " instead of " + file;
        assert (line == ste.getLineNumber()) : "Found line " + ste.getLineNumber() + " instead of " + line;
        for (int i = 2; i < stackTrace.length; ++i) {
            ste = stackTrace[i];
            if (!CoverageData.isTestMethod(ste)) continue;
            return new CallPoint(ste);
        }
        return null;
    }

    private static boolean isTestMethod(StackTraceElement ste) {
        if (steCache.containsKey(ste)) {
            return steCache.get(ste);
        }
        if (ste.getFileName() == null || ste.getLineNumber() < 0) {
            steCache.put(ste, false);
            return false;
        }
        Class<?> aClass = CoverageData.loadClass(ste.getClassName());
        Method method = CoverageData.findMethod(aClass, ste.getMethodName());
        if (method == null) {
            steCache.put(ste, false);
            return false;
        }
        boolean isTestMethod = checkTestAnnotationOnClass && aClass.isAnnotationPresent(testAnnotation) || CoverageData.containsATestFrameworkAnnotation(method.getDeclaredAnnotations()) || checkIfTestCaseSubclass && CoverageData.isJUnit3xTestMethod(aClass, method);
        steCache.put(ste, isTestMethod);
        return isTestMethod;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method findMethod(Class<?> aClass, String name) {
        for (Method method : aClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getReturnType() != Void.TYPE || !name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static boolean containsATestFrameworkAnnotation(Annotation[] methodAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            String annotationName = annotation.annotationType().getName();
            if (!annotationName.startsWith("org.junit.") && !annotationName.startsWith("org.testng.")) continue;
            return true;
        }
        return false;
    }

    private static boolean isJUnit3xTestMethod(Class<?> aClass, Method method) {
        if (!method.getName().startsWith("test")) {
            return false;
        }
        for (Class<?> superClass = aClass.getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            if (!"junit.framework.TestCase".equals(superClass.getName())) continue;
            return true;
        }
        return false;
    }

    public static void jumpTargetExecuted(String file, int line, int branchIndex) {
        if (executingCoverageCall.get().booleanValue()) {
            return;
        }
        executingCoverageCall.set(true);
        CallPoint callPoint = CoverageData.instance.withCallPoints ? CoverageData.findCallPoint(file, line, new Throwable()) : null;
        FileCoverageData fileData = instance.getFileData(file);
        fileData.registerBranchExecution(line, branchIndex, true, callPoint);
        executingCoverageCall.set(false);
    }

    public static void noJumpTargetExecuted(String file, int line, int branchIndex) {
        if (executingCoverageCall.get().booleanValue()) {
            return;
        }
        executingCoverageCall.set(true);
        CallPoint callPoint = CoverageData.instance.withCallPoints ? CoverageData.findCallPoint(file, line, new Throwable()) : null;
        FileCoverageData fileData = instance.getFileData(file);
        fileData.registerBranchExecution(line, branchIndex, false, callPoint);
        executingCoverageCall.set(false);
    }

    void fillLastModifiedTimesForAllClassFiles() {
        for (Map.Entry<String, FileCoverageData> fileAndFileData : this.fileToFileData.entrySet()) {
            File coveredClassFile = this.getClassFile(fileAndFileData.getKey());
            fileAndFileData.getValue().lastModified = coveredClassFile.lastModified();
        }
    }

    private File getClassFile(String sourceFilePath) {
        String sourceFilePathNoExt = sourceFilePath.substring(0, sourceFilePath.length() - 5);
        Class coveredClass = Utilities.loadClass((String)sourceFilePathNoExt.replace('/', '.'));
        CodeSource codeSource = coveredClass.getProtectionDomain().getCodeSource();
        String pathToClassFile = codeSource.getLocation().getPath() + sourceFilePathNoExt + ".class";
        return new File(pathToClassFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CoverageData readDataFromFile(File dataFile) throws IOException, ClassNotFoundException {
        ObjectInputStream input = new ObjectInputStream(new FileInputStream(dataFile));
        try {
            CoverageData coverageData = (CoverageData)input.readObject();
            return coverageData;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDataToFile(File dataFile) throws IOException {
        ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(dataFile));
        try {
            output.writeObject(this);
        }
        finally {
            output.close();
        }
    }

    void merge(CoverageData previousData) {
        this.withCallPoints |= previousData.withCallPoints;
        for (Map.Entry<String, FileCoverageData> previousFileAndFileData : previousData.fileToFileData.entrySet()) {
            String previousFile = previousFileAndFileData.getKey();
            FileCoverageData previousFileData = previousFileAndFileData.getValue();
            FileCoverageData fileData = this.fileToFileData.get(previousFile);
            if (fileData == null) {
                this.fileToFileData.put(previousFile, previousFileData);
                continue;
            }
            if (previousFileData.lastModified != fileData.lastModified) continue;
            fileData.addCountsFromPreviousMeasurement(previousFileData);
        }
    }

    static {
        Class<?> annotation;
        instance = new CoverageData();
        executingCoverageCall = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        steCache = new HashMap<StackTraceElement, Boolean>();
        boolean checkOnClassAlso = true;
        try {
            annotation = Class.forName("org.junit.Test");
            checkOnClassAlso = false;
        }
        catch (ClassNotFoundException ignore) {
            annotation = CoverageData.getTestNGAnnotationIfAvailable();
        }
        testAnnotation = annotation;
        checkTestAnnotationOnClass = checkOnClassAlso;
        checkIfTestCaseSubclass = CoverageData.checkForJUnit3Availability();
    }
}

