/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.coverage.BranchCoverageData;
import mockit.coverage.CoverageData;
import mockit.coverage.FileCoverageData;
import mockit.coverage.LineCoverageData;
import org.objectweb.asm2.AnnotationVisitor;
import org.objectweb.asm2.ClassReader;
import org.objectweb.asm2.ClassWriter;
import org.objectweb.asm2.Label;
import org.objectweb.asm2.MethodAdapter;
import org.objectweb.asm2.MethodVisitor;

final class CoverageModifier
extends ClassWriter {
    private final CoverageData coverageData = CoverageData.instance();
    private String sourceFileName;
    private FileCoverageData fileData;
    private boolean cannotModify;

    CoverageModifier(ClassReader cr) {
        super(cr, true);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int p = name.lastIndexOf(47);
        this.sourceFileName = p < 0 ? "" : name.substring(0, p + 1);
        this.cannotModify = name.startsWith("mockit/coverage/");
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String file, String debug) {
        this.sourceFileName = this.sourceFileName + file;
        this.fileData = this.coverageData.addFile(this.sourceFileName);
        super.visitSource(file, debug);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.cannotModify) {
            return mv;
        }
        return new MethodModifier(mv, "<clinit>".equals(name));
    }

    private final class MethodModifier
    extends MethodAdapter {
        private boolean isTestMethod;
        private int currentLine;
        private LineCoverageData lineData;
        private final List<Label> startLabelsForVisitedLines;
        private final List<Label> jumpTargetsForCurrentLine;
        private final Map<Integer, Boolean> pendingBranches;
        private boolean assertFoundInCurrentLine;
        private final boolean clinit;

        private MethodModifier(MethodVisitor mv, boolean clinit) {
            super(mv);
            this.startLabelsForVisitedLines = new ArrayList<Label>();
            this.jumpTargetsForCurrentLine = new ArrayList<Label>();
            this.pendingBranches = new HashMap<Integer, Boolean>();
            this.clinit = clinit;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.isTestMethod = desc.startsWith("Lorg/junit/") || desc.startsWith("Lorg/testng/");
            return this.mv.visitAnnotation(desc, visible);
        }

        public void visitLineNumber(int line, Label start) {
            if (this.isTestMethod) {
                this.mv.visitLineNumber(line, start);
                return;
            }
            this.lineData = CoverageModifier.this.fileData.addLine(line);
            assert (this.lineData != null);
            this.currentLine = line;
            this.startLabelsForVisitedLines.add(start);
            this.jumpTargetsForCurrentLine.clear();
            this.pendingBranches.clear();
            this.generateCallToRegisterLineExecution();
            this.mv.visitLineNumber(line, start);
        }

        private void generateCallToRegisterLineExecution() {
            this.mv.visitLdcInsn((Object)CoverageModifier.this.sourceFileName);
            this.pushCurrentLineOnTheStack();
            this.mv.visitMethodInsn(184, "mockit/coverage/CoverageData", "lineExecuted", "(Ljava/lang/String;I)V");
        }

        private void pushCurrentLineOnTheStack() {
            if (this.currentLine <= Short.MAX_VALUE) {
                this.mv.visitIntInsn(17, this.currentLine);
            } else {
                this.mv.visitLdcInsn((Object)this.currentLine);
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            if (this.isTestMethod || this.startLabelsForVisitedLines.contains(label)) {
                this.assertFoundInCurrentLine = false;
                this.mv.visitJumpInsn(opcode, label);
                return;
            }
            int jumpInsnIndex = this.lineData.addSourceElement("if");
            String jumpInsnSource = this.sourceForJumpInsn(opcode);
            this.lineData.addSourceElement(jumpInsnSource);
            this.generateCallToRegisterBranchTargetExecutionIfPending(jumpInsnSource);
            int branchIndex = this.lineData.addBranch(jumpInsnIndex);
            this.jumpTargetsForCurrentLine.add(label);
            this.pendingBranches.put(branchIndex, false);
            if (this.assertFoundInCurrentLine) {
                BranchCoverageData branchData = this.lineData.getBranchData(branchIndex);
                branchData.markAsUnreachable();
            }
            this.mv.visitJumpInsn(opcode, label);
        }

        private String sourceForJumpInsn(int opcode) {
            String source = "";
            if (opcode == 153 || opcode == 159 || opcode == 198) {
                source = "==";
            } else if (opcode == 154 || opcode == 160 || opcode == 199) {
                source = "!=";
            } else if (opcode == 156 || opcode == 162) {
                source = ">=";
            } else if (opcode == 157 || opcode == 163) {
                source = ">";
            } else if (opcode == 158 || opcode == 164) {
                source = "<=";
            } else if (opcode == 155 || opcode == 161) {
                source = "<";
            }
            if (opcode == 165) {
                source = "==";
            } else if (opcode == 166) {
                source = "!=";
            }
            return source;
        }

        private void generateCallToRegisterBranchTargetExecutionIfPending(String targetInsnSource) {
            if (!this.pendingBranches.isEmpty()) {
                int targetInsnSourceIndex = this.lineData.addSourceElement(targetInsnSource);
                for (Integer branchIndex : this.pendingBranches.keySet()) {
                    BranchCoverageData branchData = this.lineData.getBranchData(branchIndex);
                    Boolean firstInsnAfterJump = this.pendingBranches.get(branchIndex);
                    if (firstInsnAfterJump.booleanValue()) {
                        branchData.setJumpTargetInsnIndex(targetInsnSourceIndex);
                        this.generateCallToRegisterBranchTargetExecution("jumpTargetExecuted", branchIndex);
                        continue;
                    }
                    branchData.setNoJumpTargetInsnIndex(targetInsnSourceIndex);
                    this.generateCallToRegisterBranchTargetExecution("noJumpTargetExecuted", branchIndex);
                }
                this.pendingBranches.clear();
            }
        }

        public void visitLabel(Label label) {
            this.mv.visitLabel(label);
            int branchIndex = this.jumpTargetsForCurrentLine.indexOf(label);
            if (branchIndex >= 0) {
                this.pendingBranches.put(branchIndex, true);
                this.assertFoundInCurrentLine = false;
            }
        }

        private void generateCallToRegisterBranchTargetExecution(String methodName, int branchIndex) {
            this.mv.visitLdcInsn((Object)CoverageModifier.this.sourceFileName);
            this.pushCurrentLineOnTheStack();
            this.mv.visitIntInsn(17, branchIndex);
            this.mv.visitMethodInsn(184, "mockit/coverage/CoverageData", methodName, "(Ljava/lang/String;II)V");
        }

        public void visitInsn(int opcode) {
            String source = opcode >= 172 && opcode <= 177 ? "return" : "*";
            if (opcode > 15) {
                this.generateCallToRegisterBranchTargetExecutionIfPending(source);
            }
            this.mv.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.generateCallToRegisterBranchTargetExecutionIfPending("*");
            this.mv.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            String source = "";
            if (!(opcode >= 21 && opcode <= 25 || opcode >= 54 && opcode <= 58)) {
                source = "return";
            }
            this.generateCallToRegisterBranchTargetExecutionIfPending(source);
            this.mv.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String desc) {
            String source = opcode == 187 || opcode == 189 ? "new" : (opcode == 193 ? "instanceof" : "(" + desc + ")");
            this.generateCallToRegisterBranchTargetExecutionIfPending(source);
            this.mv.visitTypeInsn(opcode, desc);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.assertFoundInCurrentLine = opcode == 178 && "$assertionsDisabled".equals(name);
            String source = owner + "." + name;
            source = opcode == 178 || opcode == 180 ? "=" + source : source + "=";
            this.generateCallToRegisterBranchTargetExecutionIfPending(source);
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.assertFoundInCurrentLine = this.clinit && opcode == 182 && "java/lang/Class".equals(owner) && "desiredAssertionStatus".equals(name);
            this.generateCallToRegisterBranchTargetExecutionIfPending(owner + "." + name + "()");
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            this.generateCallToRegisterBranchTargetExecutionIfPending(cst.toString());
            this.mv.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            String source = "v" + var;
            source = increment > 0 ? source + "+=" + increment : source + "-=" + -increment;
            this.generateCallToRegisterBranchTargetExecutionIfPending(source);
            this.mv.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            this.generateCallToRegisterBranchTargetExecutionIfPending("case");
            this.mv.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.generateCallToRegisterBranchTargetExecutionIfPending("case2");
            this.mv.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.generateCallToRegisterBranchTargetExecutionIfPending(desc + "[]" + dims);
            this.mv.visitMultiANewArrayInsn(desc, dims);
        }
    }
}

