/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import mockit.coverage.CallPoint;
import mockit.coverage.LineCoverageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileCoverageData
implements Serializable {
    private static final long serialVersionUID = 3508592808457531011L;
    long lastModified;
    private final SortedMap<Integer, LineCoverageData> lineToLineData = new TreeMap<Integer, LineCoverageData>();

    LineCoverageData addLine(int line) {
        if (this.lineToLineData.containsKey(line)) {
            return (LineCoverageData)this.lineToLineData.get(line);
        }
        LineCoverageData lineData = new LineCoverageData();
        this.lineToLineData.put(line, lineData);
        return lineData;
    }

    void incrementLineCount(int line, CallPoint callPoint) {
        LineCoverageData lineData = (LineCoverageData)this.lineToLineData.get(line);
        lineData.registerExecution(callPoint);
    }

    void registerBranchExecution(int line, int branchIndex, boolean jumped, CallPoint callPoint) {
        LineCoverageData lineData = (LineCoverageData)this.lineToLineData.get(line);
        lineData.registerExecution(branchIndex, jumped, callPoint);
    }

    public SortedMap<Integer, LineCoverageData> getLineToLineData() {
        return Collections.unmodifiableSortedMap(this.lineToLineData);
    }

    public int getCoveragePercentage() {
        if (this.lineToLineData.isEmpty()) {
            return 100;
        }
        Collection<LineCoverageData> lines = this.lineToLineData.values();
        int result = 0;
        for (LineCoverageData line : lines) {
            result += line.getCoveragePercentage();
        }
        return (int)((double)result / (double)lines.size() + 0.5);
    }

    void addCountsFromPreviousMeasurement(FileCoverageData previousData) {
        Integer line;
        SortedMap<Integer, LineCoverageData> previousLineToLineData = previousData.lineToLineData;
        for (Map.Entry<Integer, LineCoverageData> lineAndData : this.lineToLineData.entrySet()) {
            line = lineAndData.getKey();
            LineCoverageData previousLineData = (LineCoverageData)previousLineToLineData.get(line);
            if (previousLineData == null) continue;
            LineCoverageData lineData = lineAndData.getValue();
            lineData.addCountsFromPreviousMeasurement(previousLineData);
        }
        for (Map.Entry<Integer, LineCoverageData> lineAndData : previousLineToLineData.entrySet()) {
            line = lineAndData.getKey();
            if (this.lineToLineData.containsKey(line)) continue;
            this.lineToLineData.put(line, lineAndData.getValue());
        }
    }
}

