/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mockit.coverage.BranchCoverageData;
import mockit.coverage.CallPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LineCoverageData
implements Serializable {
    private static final long serialVersionUID = -6233980722802474992L;
    private boolean unreachable;
    private List<BranchCoverageData> branches;
    private transient List<String> sourceElements;
    private List<CallPoint> callPoints;
    private int executionCount;

    int addBranch(int jumpInsnIndex) {
        if (this.branches == null) {
            this.branches = new ArrayList<BranchCoverageData>(4);
        }
        BranchCoverageData branchData = new BranchCoverageData(jumpInsnIndex);
        this.branches.add(branchData);
        return this.branches.size() - 1;
    }

    int addSourceElement(String sourceElement) {
        if (this.sourceElements == null) {
            this.sourceElements = new ArrayList<String>(8);
        }
        if (sourceElement.length() > 0) {
            this.sourceElements.add(sourceElement);
        }
        return this.sourceElements.size() - 1;
    }

    BranchCoverageData getBranchData(int branchIndex) {
        return this.branches.get(branchIndex);
    }

    void registerExecution(CallPoint callPoint) {
        if (callPoint != null) {
            if (this.callPoints == null) {
                this.callPoints = new ArrayList<CallPoint>();
            }
            this.callPoints.add(callPoint);
        }
        ++this.executionCount;
    }

    void registerExecution(int branchIndex, boolean jumped, CallPoint callPoint) {
        BranchCoverageData branchData = this.branches.get(branchIndex);
        if (jumped) {
            branchData.registerJumpExecution(callPoint);
        } else {
            branchData.registerNoJumpExecution(callPoint);
        }
    }

    public boolean containsBranches() {
        return this.branches != null;
    }

    public List<BranchCoverageData> getBranches() {
        return this.branches == null ? Collections.emptyList() : Collections.unmodifiableList(this.branches);
    }

    public List<String> getSourceElements() {
        return this.sourceElements == null ? Collections.emptyList() : Collections.unmodifiableList(this.sourceElements);
    }

    public boolean containsCallPoints() {
        return this.callPoints != null;
    }

    public List<CallPoint> getCallPoints() {
        return this.callPoints == null ? Collections.emptyList() : Collections.unmodifiableList(this.callPoints);
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public void markAsUnreachable() {
        this.unreachable = true;
    }

    public int getCoveragePercentage() {
        if (this.unreachable) {
            return 100;
        }
        if (this.executionCount == 0) {
            return 0;
        }
        if (this.branches == null) {
            return 100;
        }
        int branchesCovered = 0;
        for (BranchCoverageData branch : this.branches) {
            if (!branch.isCovered()) continue;
            ++branchesCovered;
        }
        return 100 * branchesCovered / this.branches.size();
    }

    void addCountsFromPreviousMeasurement(LineCoverageData previousData) {
        this.executionCount += previousData.executionCount;
        if (previousData.containsCallPoints()) {
            if (this.containsCallPoints()) {
                this.callPoints.addAll(0, previousData.callPoints);
            } else {
                this.callPoints = previousData.callPoints;
            }
        }
        if (this.containsBranches()) {
            for (int i = 0; i < this.branches.size(); ++i) {
                BranchCoverageData branchData = this.branches.get(i);
                BranchCoverageData previousBranchData = previousData.branches.get(i);
                branchData.addCountsFromPreviousMeasurement(previousBranchData);
            }
        }
    }
}

