/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import mockit.coverage.AccretionFile;
import mockit.coverage.CoverageData;
import mockit.coverage.output.BasicXmlWriter;
import mockit.coverage.output.FullXmlWriter;
import mockit.coverage.reporting.BasicCoverageReport;
import mockit.coverage.reporting.FullCoverageReport;

final class OutputFileGenerator
extends Thread {
    private final String outputFormat;
    private final String outputDir;
    private final String[] sourceDirs;
    private String[] classPath;

    OutputFileGenerator(String outputFormat, String outputDir, String[] sourceDirs) {
        String format;
        this.outputDir = outputDir;
        this.sourceDirs = sourceDirs;
        String string = format = outputFormat.length() > 0 ? outputFormat : this.outputFormatFromClasspath();
        if (format.length() == 0) {
            format = "html-nocp";
        }
        this.outputFormat = format;
    }

    private String outputFormatFromClasspath() {
        this.classPath = System.getProperty("java.class.path").split(File.pathSeparator);
        String result = "";
        if (this.availableInTheClasspath("xmlbasic")) {
            result = "xml-nocp";
        } else if (this.availableInTheClasspath("xmlfull")) {
            result = "xml";
        }
        if (this.availableInTheClasspath("htmlbasic")) {
            result = result + " html-nocp";
        } else if (this.availableInTheClasspath("htmlfull")) {
            result = result + " html";
        }
        if (this.availableInTheClasspath("merge")) {
            result = result + " merge";
        }
        return result;
    }

    private boolean availableInTheClasspath(String jarFileNameSuffix) {
        String desiredJarFile = "jmockit-coverage-" + jarFileNameSuffix + ".jar";
        for (String cpEntry : this.classPath) {
            if (!cpEntry.endsWith(desiredJarFile)) continue;
            return true;
        }
        return false;
    }

    boolean isOutputToBeGenerated() {
        return this.outputFormat.length() > 0;
    }

    boolean isWithCallPoints() {
        return this.outputFormat.contains("xml") && !this.outputFormat.contains("xml-nocp") || this.outputFormat.contains("html") && !this.outputFormat.contains("html-nocp");
    }

    public void run() {
        this.createOutputDirIfSpecifiedButNotExists();
        CoverageData coverageData = CoverageData.instance();
        try {
            this.generateAccretionDataFileIfRequested(coverageData);
            this.generateXMLOutputFileIfRequested(coverageData);
            this.generateHTMLReportIfRequested(coverageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void createOutputDirIfSpecifiedButNotExists() {
        File outDir;
        if (this.outputDir.length() > 0 && !(outDir = new File(this.outputDir)).exists()) {
            boolean dirCreated = outDir.mkdir();
            assert (dirCreated) : "Failed to create specified output dir: " + this.outputDir;
        }
    }

    private void generateAccretionDataFileIfRequested(CoverageData newData) throws IOException, ClassNotFoundException {
        if (this.outputFormat.contains("merge")) {
            new AccretionFile(this.outputDir).generate(newData);
        }
    }

    private void generateXMLOutputFileIfRequested(CoverageData coverageData) throws IOException {
        if (this.outputFormat.contains("xml-nocp")) {
            new BasicXmlWriter(coverageData).writeToXmlFile(this.outputDir);
        } else if (this.outputFormat.contains("xml")) {
            new FullXmlWriter(coverageData).writeToXmlFile(this.outputDir);
        }
    }

    private void generateHTMLReportIfRequested(CoverageData coverageData) throws IOException {
        if (this.outputFormat.contains("html-nocp")) {
            new BasicCoverageReport(this.outputDir, this.sourceDirs, coverageData).generate();
        } else if (this.outputFormat.contains("html")) {
            new FullCoverageReport(this.outputDir, this.sourceDirs, coverageData).generate();
        }
    }
}

