/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.output;

import java.io.IOException;
import java.util.List;
import mockit.coverage.BranchCoverageData;
import mockit.coverage.CallPoint;
import mockit.coverage.CoverageData;
import mockit.coverage.LineCoverageData;
import mockit.coverage.output.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FullXmlWriter
extends XmlWriter {
    public FullXmlWriter(CoverageData coverageData) {
        super(coverageData);
    }

    @Override
    protected boolean writeChildElementsForLine(LineCoverageData lineData) throws IOException {
        if (lineData.containsCallPoints()) {
            this.output.write("'>");
            this.output.newLine();
            this.writeChildElementsForCallPoints(lineData.getCallPoints(), "");
            return true;
        }
        return false;
    }

    @Override
    protected void writeEndTagForBranch(BranchCoverageData branchData, int jumpCount, int noJumpCount) throws IOException {
        this.output.write(">");
        this.output.newLine();
        if (jumpCount > 0) {
            this.writeChildElementsForCallPoints(branchData.getJumpCallPoints(), "  ");
        }
        if (noJumpCount > 0) {
            this.writeChildElementsForCallPoints(branchData.getNoJumpCallPoints(), "  ");
        }
        this.output.write("      </branch>");
    }

    private boolean writeChildElementsForCallPoints(List<CallPoint> callPoints, String indent) throws IOException {
        for (CallPoint callPoint : callPoints) {
            StackTraceElement ste = callPoint.getStackTraceElement();
            this.output.write(indent);
            this.output.write("      <callPoint class='");
            this.output.write(ste.getClassName());
            this.output.write("' method='");
            this.output.write(ste.getMethodName());
            this.output.write("' line='");
            this.output.write(String.valueOf(ste.getLineNumber()));
            this.output.write("'/>");
            this.output.newLine();
        }
        return true;
    }
}

