/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import mockit.coverage.BranchCoverageData;
import mockit.coverage.CoverageData;
import mockit.coverage.FileCoverageData;
import mockit.coverage.LineCoverageData;

public abstract class XmlWriter {
    private final CoverageData coverageData;
    protected BufferedWriter output;

    protected XmlWriter(CoverageData coverageData) {
        this.coverageData = coverageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToXmlFile(String outputDir) throws IOException {
        File outputFile = new File(outputDir.length() == 0 ? null : outputDir, "coverage.xml");
        if (outputFile.exists() && !outputFile.canWrite()) {
            System.out.println("JMockit: " + outputFile.getCanonicalPath() + " is read-only; file generation canceled");
            return;
        }
        this.output = new BufferedWriter(new FileWriter(outputFile));
        try {
            this.writeXmlDocument();
        }
        finally {
            this.output.close();
            System.out.println("\nJMockit: Coverage data written to " + outputFile.getCanonicalPath());
        }
    }

    private void writeXmlDocument() throws IOException {
        this.writeLine("<?xml version='1.0' encoding='UTF-8'?>");
        this.writeLine("<coverage>");
        Map<String, FileCoverageData> fileToFileData = this.coverageData.getFileToFileDataMap();
        for (Map.Entry<String, FileCoverageData> lineCountEntry : fileToFileData.entrySet()) {
            this.output.write("  <file path='");
            this.output.write(lineCountEntry.getKey());
            this.writeLine("'>");
            FileCoverageData fileCoverageData = lineCountEntry.getValue();
            this.writeCoverageDataForSourceFile(fileCoverageData);
            this.writeLine("  </file>");
            this.output.newLine();
        }
        this.writeLine("</coverage>");
    }

    private void writeLine(String line) throws IOException {
        this.output.write(line);
        this.output.newLine();
    }

    private void writeCoverageDataForSourceFile(FileCoverageData fileData) throws IOException {
        SortedMap<Integer, LineCoverageData> lineToLineData = fileData.getLineToLineData();
        for (Map.Entry<Integer, LineCoverageData> lineAndLineData : lineToLineData.entrySet()) {
            Integer line = lineAndLineData.getKey();
            LineCoverageData lineData = lineAndLineData.getValue();
            this.output.write("    <line number='");
            this.output.write(line.toString());
            this.output.write("' count='");
            this.output.write(String.valueOf(lineData.getExecutionCount()));
            boolean pendingEndTag = false;
            if (lineData.containsBranches()) {
                this.writeChildElementsForBranches(lineData);
                pendingEndTag = true;
            } else if (this.writeChildElementsForLine(lineData)) {
                pendingEndTag = true;
            }
            this.writeLine(pendingEndTag ? "    </line>" : "'/>");
        }
    }

    protected abstract boolean writeChildElementsForLine(LineCoverageData var1) throws IOException;

    private boolean writeChildElementsForBranches(LineCoverageData lineData) throws IOException {
        this.writeAttributeWithSourceElements(lineData);
        for (BranchCoverageData branchData : lineData.getBranches()) {
            int jumpTargetInsnIndex = branchData.getJumpTargetInsnIndex();
            int jumpCount = branchData.getJumpExecutionCount();
            int noJumpTargetInsnIndex = branchData.getNoJumpTargetInsnIndex();
            int noJumpCount = branchData.getNoJumpExecutionCount();
            if (jumpTargetInsnIndex < 0 && noJumpTargetInsnIndex < 0) continue;
            this.output.write("      <branch jumpInsn='");
            this.output.write(String.valueOf(branchData.getJumpInsnIndex()));
            this.output.write("'");
            if (noJumpTargetInsnIndex >= 0) {
                this.output.write(" noJumpTargetInsn='");
                this.output.write(String.valueOf(noJumpTargetInsnIndex));
                this.output.write("' noJumpCount='");
                this.output.write(String.valueOf(noJumpCount));
                this.output.write("'");
            }
            if (jumpTargetInsnIndex >= 0) {
                this.output.write(" jumpTargetInsn='");
                this.output.write(String.valueOf(jumpTargetInsnIndex));
                this.output.write("' jumpCount='");
                this.output.write(String.valueOf(jumpCount));
                this.output.write("'");
            }
            this.writeEndTagForBranch(branchData, jumpCount, noJumpCount);
            this.output.newLine();
        }
        return true;
    }

    private void writeAttributeWithSourceElements(LineCoverageData lineData) throws IOException {
        String sep = "' source='";
        for (String sourceElement : lineData.getSourceElements()) {
            this.output.write(sep);
            this.output.write(sourceElement);
            sep = " ";
        }
        this.writeLine("'>");
    }

    protected abstract void writeEndTagForBranch(BranchCoverageData var1, int var2, int var3) throws IOException;
}

