/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import mockit.coverage.CoverageData;
import mockit.coverage.FileCoverageData;
import mockit.coverage.reporting.FileCoverageReport;
import mockit.coverage.reporting.IndexPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoverageReport {
    private static final String CSS_FILE_NAME = "coverage.css";
    private static final Pattern PATH_SEPARATOR = Pattern.compile("/");
    private final String outputDir;
    private final List<File> sourceDirs;
    private final Map<String, FileCoverageData> filesToFileData;
    private final Map<String, List<String>> packagesToFiles;
    private final boolean withCallPoints;

    protected CoverageReport(String outputDir, String[] sourceDirs, CoverageData coverageData, boolean withCallPoints) {
        this.outputDir = outputDir.length() > 0 ? outputDir : "coverage-report";
        boolean useSpecifiedSrcDirs = sourceDirs.length > 0;
        List<File> list = this.sourceDirs = useSpecifiedSrcDirs ? this.asFiles(sourceDirs) : this.allSrcSubDirs();
        if (this.sourceDirs.isEmpty()) {
            if (useSpecifiedSrcDirs) {
                throw new IllegalStateException("None of the specified source directories exist");
            }
            throw new IllegalStateException("No \"src\" directories found under \"" + new File("").getAbsolutePath() + '\"');
        }
        this.filesToFileData = coverageData.getFileToFileDataMap();
        this.packagesToFiles = new HashMap<String, List<String>>();
        this.withCallPoints = withCallPoints;
    }

    private List<File> asFiles(String[] dirs) {
        ArrayList<File> result = new ArrayList<File>(dirs.length);
        for (String dir : dirs) {
            File srcDir = new File(dir);
            if (!srcDir.isDirectory()) continue;
            result.add(srcDir);
        }
        return result;
    }

    private List<File> allSrcSubDirs() {
        ArrayList<File> srcSubDirs = new ArrayList<File>();
        this.addSrcSubDirs(new File("."), srcSubDirs);
        return srcSubDirs;
    }

    private void addSrcSubDirs(File dir, List<File> srcSubDirs) {
        for (File subDir : dir.listFiles()) {
            if (!subDir.isDirectory()) continue;
            if ("src".equals(subDir.getName())) {
                srcSubDirs.add(subDir);
                continue;
            }
            this.addSrcSubDirs(subDir, srcSubDirs);
        }
    }

    public final void generate() throws IOException {
        if (this.filesToFileData.isEmpty()) {
            return;
        }
        this.createOutputDirIfNotExists();
        File outputFile = new File(this.outputDir, "index.html");
        if (outputFile.exists() && !outputFile.canWrite()) {
            System.out.println("JMockit: " + outputFile.getCanonicalPath() + " is read-only; report generation canceled");
            return;
        }
        if (this.sourceDirs.size() > 1) {
            System.out.println("JMockit: Coverage source dirs: " + this.sourceDirs);
        }
        this.generateFileCoverageReportsWhileBuildingPackageLists();
        new IndexPage(outputFile).generate(this.filesToFileData, this.packagesToFiles);
        this.copyCSSFile();
        System.out.println("JMockit: Coverage report written to " + new File(this.outputDir).getCanonicalPath());
    }

    private void createOutputDirIfNotExists() {
        File outDir = new File(this.outputDir);
        if (!outDir.exists()) {
            boolean dirCreated = outDir.mkdir();
            assert (dirCreated) : "Failed to create output dir: " + this.outputDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCSSFile() throws IOException {
        InputStream cssFileIn = this.getClass().getResourceAsStream(CSS_FILE_NAME);
        FileOutputStream cssFileOut = new FileOutputStream(new File(this.outputDir, CSS_FILE_NAME));
        try {
            int b;
            while ((b = cssFileIn.read()) != -1) {
                cssFileOut.write(b);
            }
        }
        finally {
            try {
                cssFileIn.close();
            }
            finally {
                cssFileOut.close();
            }
        }
    }

    private void generateFileCoverageReportsWhileBuildingPackageLists() throws IOException {
        Set<Map.Entry<String, FileCoverageData>> files = this.filesToFileData.entrySet();
        for (Map.Entry<String, FileCoverageData> fileAndFileData : files) {
            FileCoverageData fileData;
            String file = fileAndFileData.getKey();
            FileCoverageReport fileReport = new FileCoverageReport(this.outputDir, this.sourceDirs, file, fileData = fileAndFileData.getValue(), this.withCallPoints);
            if (!fileReport.wasSourceFileFound()) continue;
            fileReport.generate();
            this.addFileToPackageFileList(file);
        }
    }

    private void addFileToPackageFileList(String file) {
        int p = file.lastIndexOf(47);
        String filePackage = p < 0 ? "" : file.substring(0, p);
        List<String> filesInPackage = this.packagesToFiles.get(filePackage);
        if (filesInPackage == null) {
            filesInPackage = new ArrayList<String>();
            this.packagesToFiles.put(filePackage, filesInPackage);
        }
        filesInPackage.add(file);
    }

    static void writeCommonFileHeader(PrintWriter output, String pathToFile) {
        output.println("<?xml version='1.0' encoding='UTF-8'?>");
        output.println("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
        output.println("<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>");
        output.println("<head>");
        output.println("  <title>JMockit Coverage Report</title>");
        output.println("  <meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>");
        output.print("  <link rel='stylesheet' type='text/css' href='");
        String pathToCSSFile = CoverageReport.getRelativePathToCSSFile(pathToFile);
        output.print(pathToCSSFile);
        output.println("'/>");
    }

    private static String getRelativePathToCSSFile(String filePath) {
        StringBuilder cssRelPath = new StringBuilder();
        int n = PATH_SEPARATOR.split(filePath).length;
        for (int i = 1; i < n; ++i) {
            cssRelPath.append("../");
        }
        return cssRelPath + CSS_FILE_NAME;
    }
}

