/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import mockit.coverage.FileCoverageData;
import mockit.coverage.LineCoverageData;
import mockit.coverage.reporting.CoverageReport;
import mockit.coverage.reporting.LineCoverageFormatter;
import mockit.coverage.reporting.LineParser;
import mockit.coverage.reporting.LineSegment;
import mockit.coverage.reporting.LineSyntaxFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileCoverageReport {
    private final Map<Integer, LineCoverageData> lineToLineData;
    private final File inputFile;
    private final BufferedReader input;
    private final String pathToOutputFile;
    private final PrintWriter output;
    private final boolean withCallPoints;
    private final LineParser lineParser = new LineParser();
    private final LineSyntaxFormatter lineSyntaxFormatter = new LineSyntaxFormatter();
    private final LineCoverageFormatter lineCoverageFormatter;
    private String line;
    private LineCoverageData lineData;

    FileCoverageReport(String outputDir, List<File> sourceDirs, String filePath, FileCoverageData coverageData, boolean withCallPoints) throws IOException {
        this.lineToLineData = coverageData.getLineToLineData();
        this.inputFile = this.findSourceFile(sourceDirs, filePath);
        this.pathToOutputFile = filePath.replace(".java", ".html");
        this.withCallPoints = withCallPoints;
        this.lineCoverageFormatter = new LineCoverageFormatter(withCallPoints);
        if (this.inputFile == null) {
            this.input = null;
            this.output = null;
            return;
        }
        this.input = new BufferedReader(new FileReader(this.inputFile));
        File outputFile = this.getOutputFileCreatingOutputDirIfNonExisting(outputDir);
        this.output = new PrintWriter(new FileWriter(outputFile));
    }

    private File findSourceFile(List<File> sourceDirs, String filePath) {
        int p = filePath.indexOf(47);
        String topLevelPackage = p < 0 ? "" : filePath.substring(0, p);
        for (File sourceDir : sourceDirs) {
            File file = this.getSourceFile(sourceDir, topLevelPackage, filePath);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private File getSourceFile(File sourceDir, String topLevelPackage, String filePath) {
        File[] subDirs;
        File sourceFile = new File(sourceDir, filePath);
        if (sourceFile.exists()) {
            return sourceFile;
        }
        for (File subDir : subDirs = sourceDir.listFiles()) {
            if (!subDir.isDirectory() || subDir.isHidden() || subDir.getName().equals(topLevelPackage) || (sourceFile = this.getSourceFile(subDir, topLevelPackage, filePath)) == null) continue;
            return sourceFile;
        }
        return null;
    }

    private File getOutputFileCreatingOutputDirIfNonExisting(String outputDir) {
        File outputFile = new File(outputDir, this.pathToOutputFile);
        File parentDir = outputFile.getParentFile();
        if (!parentDir.exists()) {
            boolean outputDirCreated = parentDir.mkdirs();
            assert (outputDirCreated) : "Failed to create output dir: " + outputDir;
        }
        return outputFile;
    }

    boolean wasSourceFileFound() {
        return this.inputFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generate() throws IOException {
        try {
            this.writeHeader();
            this.writeFormattedSourceLines();
            this.writeFooter();
        }
        finally {
            this.input.close();
            this.output.close();
        }
    }

    private void writeHeader() {
        CoverageReport.writeCommonFileHeader(this.output, this.pathToOutputFile);
        if (this.withCallPoints) {
            this.output.println("  <script type='text/javascript'>");
            this.output.println("    function showHide(callPoints) {");
            this.output.println("      var list = callPoints.nextSibling.nextSibling.style;");
            this.output.println("      list.display = list.display == 'none' ? 'block' : 'none';");
            this.output.println("    }");
            this.output.println("  </script>");
        }
        this.output.println("</head>");
        this.output.println("<body>");
        this.output.println("  <table cellpadding='0' cellspacing='1'>");
        this.output.println("    <caption><code>" + this.inputFile.getPath() + "</code></caption>");
    }

    private void writeFormattedSourceLines() throws IOException {
        int lineNo = 1;
        while ((this.line = this.input.readLine()) != null) {
            this.lineData = this.lineToLineData.get(lineNo);
            this.output.println("    <tr>");
            this.output.print("      <td class='lineNo'>");
            this.output.print(lineNo);
            this.output.print("</td>");
            this.writeLineExecutionCountIfAny();
            this.writeFormattedSourceLine();
            this.output.println("    </tr>");
            ++lineNo;
        }
    }

    private void writeLineExecutionCountIfAny() {
        if (this.lineData != null) {
            this.output.print("<td class='count'>");
            this.output.print(this.lineData.getExecutionCount());
            this.output.println("</td>");
        } else {
            this.output.println("<td>&nbsp;</td>");
        }
    }

    private void writeFormattedSourceLine() {
        String lineStatus;
        if (this.line.trim().length() == 0) {
            this.output.println("      <td/>");
            return;
        }
        LineSegment initialSegment = this.lineParser.parse(this.line);
        this.lineSyntaxFormatter.format(initialSegment);
        String string = this.lineData == null ? "nonexec" : (lineStatus = this.lineData.getExecutionCount() == 0 ? "uncovered" : null);
        if (lineStatus != null) {
            this.output.print("      <td class='");
            this.output.print(lineStatus);
            this.output.print("'><pre>");
            this.output.print(initialSegment.toString());
            this.output.println("</pre></td>");
        } else {
            this.line = this.lineCoverageFormatter.format(this.lineData, initialSegment);
            this.output.print(this.line);
        }
    }

    private void writeFooter() {
        this.output.println("  </table>");
        this.output.println("</body>");
        this.output.println("</html>");
    }
}

