/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.coverage.FileCoverageData;
import mockit.coverage.reporting.CoverageReport;
import mockit.coverage.reporting.ListWithFilesAndPercentages;
import mockit.coverage.reporting.PackageCoverageReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IndexPage
extends ListWithFilesAndPercentages {
    private Map<String, List<String>> packagesToFiles;
    private Map<String, Integer> packagesToPackagePercentages;
    private PackageCoverageReport packageReport;

    IndexPage(File outputFile) throws IOException {
        super(new PrintWriter(new FileWriter(outputFile)), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generate(Map<String, FileCoverageData> filesToFileData, Map<String, List<String>> packagesToFiles) {
        this.packagesToFiles = packagesToFiles;
        this.packageReport = new PackageCoverageReport(this.output, filesToFileData);
        this.packagesToPackagePercentages = new HashMap<String, Integer>();
        try {
            this.writeHeader();
            ArrayList<String> packages = new ArrayList<String>(packagesToFiles.keySet());
            this.writeMetricForEachFile(packages);
            this.writeFooter();
        }
        finally {
            this.output.close();
        }
    }

    private void writeHeader() {
        CoverageReport.writeCommonFileHeader(this.output, "index.html");
        this.output.println("</head>");
        this.output.println("<body>");
        this.output.println("  <h1>JMockit Coverage Report</h1>");
        this.output.println("  <table cellpadding='0' cellspacing='1'>");
        this.output.println("    <caption>All Packages and Files</caption>");
        this.output.print("    <tr><th>Packages (");
        this.output.print(this.packagesToFiles.keySet().size());
        this.output.print(")</th><th>Files (");
        int totalFileCount = 0;
        for (List<String> files : this.packagesToFiles.values()) {
            totalFileCount += files.size();
        }
        this.output.print(totalFileCount);
        this.output.println(")</th><th>Coverage</th></tr>");
    }

    private void writeFooter() {
        this.output.println("  </table>");
        this.output.print("<p>Generated on ");
        this.output.print(new Date());
        this.output.println("</p>");
        this.output.println("</body>");
        this.output.println("</html>");
    }

    @Override
    protected int getCoveragePercentageForFile(String filePath) {
        return this.packagesToPackagePercentages.get(filePath);
    }

    @Override
    protected String getHRefToFile(String filePath) {
        return null;
    }

    @Override
    protected String getFileNameForDisplay(String filePath) {
        return filePath.replace('/', '.');
    }

    @Override
    protected void writeInternalTableForChildren(String filePath) {
        this.printIndent(3);
        this.output.println("<td>");
        this.printIndent(4);
        this.output.println("<table width='100%' cellpadding='1' cellspacing='1'>");
        List<String> packageFiles = this.packagesToFiles.get(filePath);
        int packagePercentage = this.packageReport.writeMetricForEachFile(packageFiles);
        this.packagesToPackagePercentages.put(filePath, packagePercentage);
        this.printIndent(4);
        this.output.println("</table>");
        this.printIndent(3);
        this.output.println("</td>");
    }
}

