/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import mockit.coverage.LineCoverageData;
import mockit.coverage.reporting.LineSegment;
import mockit.coverage.reporting.ListOfCallPoints;

final class LineCoverageFormatter {
    private static final String EOL = System.getProperty("line.separator");
    private final boolean withCallPoints;
    private final StringBuilder formattedLine = new StringBuilder(200);

    LineCoverageFormatter(boolean withCallPoints) {
        this.withCallPoints = withCallPoints;
    }

    String format(LineCoverageData lineData, LineSegment initialSegment) {
        this.formattedLine.setLength(0);
        if (lineData.containsBranches()) {
            this.formatLineWithBranches(lineData, initialSegment);
        } else {
            this.formatLineWithoutBranches(lineData, initialSegment);
        }
        this.formattedLine.append("      </td>").append(EOL);
        return this.formattedLine.toString();
    }

    private void formatLineWithBranches(LineCoverageData lineData, LineSegment initialSegment) {
        if (lineData.getCoveragePercentage() == 100) {
            this.formattedLine.append("      <td><pre class='covered");
        } else {
            this.formattedLine.append("      <td><pre class='partiallyCovered");
        }
        if (this.withCallPoints) {
            this.formattedLine.append(" withCallPoints' onclick='showHide(this)");
        }
        this.formattedLine.append("'>");
        this.formattedLine.append(initialSegment.toString());
        this.formattedLine.append("</pre>").append(EOL);
        if (this.withCallPoints) {
            new ListOfCallPoints().insertListOfCallPoints(this.formattedLine, lineData.getCallPoints());
        }
    }

    private void formatLineWithoutBranches(LineCoverageData lineData, LineSegment initialSegment) {
        this.formattedLine.append("      <td><pre class='covered");
        if (this.withCallPoints) {
            this.formattedLine.append(" withCallPoints' onclick='showHide(this)");
        }
        this.formattedLine.append("'>");
        this.formattedLine.append(initialSegment.toString());
        this.formattedLine.append("</pre>").append(EOL);
        if (this.withCallPoints) {
            new ListOfCallPoints().insertListOfCallPoints(this.formattedLine, lineData.getCallPoints());
        }
    }
}

