/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import mockit.coverage.reporting.LineSegment;

final class LineParser {
    private static final String SEPARATORS = ".,;:()";
    private LineSegment initialSegment;
    private LineSegment currentSegment;
    private boolean inComments;
    private String line;
    private int lineLength;
    private int startPos;
    private boolean inCodeSegment;
    private int pos;
    private int currChar;

    LineParser() {
    }

    LineSegment parse(String line) {
        this.initialSegment = null;
        this.currentSegment = null;
        this.line = line;
        this.lineLength = line.length();
        this.startPos = this.inComments ? 0 : -1;
        this.inCodeSegment = false;
        this.pos = 0;
        while (this.pos < this.lineLength) {
            this.currChar = line.codePointAt(this.pos);
            if (this.parseComment()) break;
            this.parseSeparatorsAndCode();
            ++this.pos;
        }
        if (this.startPos >= 0) {
            this.addSegment(0);
        }
        return this.initialSegment;
    }

    private void parseSeparatorsAndCode() {
        boolean separator = this.isSeparator();
        if (!this.inCodeSegment && separator) {
            this.startNewSegmentIfNotYetStarted();
        } else if (!this.inCodeSegment && !separator) {
            if (this.startPos >= 0) {
                this.addSegment(this.pos);
            }
            this.inCodeSegment = true;
            this.startPos = this.pos;
        } else if (separator) {
            this.addSegment(this.pos);
            this.inCodeSegment = false;
            this.startPos = this.pos;
        }
    }

    private boolean isSeparator() {
        return Character.isWhitespace(this.currChar) || SEPARATORS.indexOf(this.currChar) >= 0;
    }

    private void startNewSegmentIfNotYetStarted() {
        if (this.startPos < 0) {
            this.startPos = this.pos;
        }
    }

    private boolean parseComment() {
        if (this.inComments && this.parseUntilEndOfLineOrEndOfComment()) {
            return true;
        }
        while (this.currChar == 47 && this.pos < this.lineLength - 1) {
            int c2 = this.line.codePointAt(this.pos + 1);
            if (c2 == 47) {
                this.endCodeSegmentIfPending();
                this.startNewSegmentIfNotYetStarted();
                this.inComments = true;
                this.addSegment(0);
                this.inComments = false;
                this.startPos = -1;
                return true;
            }
            if (c2 != 42) break;
            this.endCodeSegmentIfPending();
            this.startNewSegmentIfNotYetStarted();
            this.inComments = true;
            this.pos += 2;
            if (!this.parseUntilEndOfLineOrEndOfComment()) continue;
            return true;
        }
        return false;
    }

    private void endCodeSegmentIfPending() {
        if (this.inCodeSegment) {
            this.addSegment(this.pos);
            this.startPos = this.pos;
            this.inCodeSegment = false;
        }
    }

    private boolean parseUntilEndOfLineOrEndOfComment() {
        while (this.pos < this.lineLength) {
            this.currChar = this.line.codePointAt(this.pos);
            if (this.currChar == 42 && this.pos < this.lineLength - 1 && this.line.codePointAt(this.pos + 1) == 47) {
                this.pos += 2;
                this.addSegment(this.pos);
                this.startPos = -1;
                this.inComments = false;
                break;
            }
            ++this.pos;
        }
        if (this.pos < this.lineLength) {
            this.currChar = this.line.codePointAt(this.pos);
            return false;
        }
        return true;
    }

    private void addSegment(int p) {
        String segmentText;
        String string = segmentText = p > 0 ? this.line.substring(this.startPos, p) : this.line.substring(this.startPos);
        LineSegment.SegmentType segmentType = this.inComments ? LineSegment.SegmentType.COMMENT : (this.inCodeSegment ? LineSegment.SegmentType.CODE : LineSegment.SegmentType.SEPARATOR);
        LineSegment newSegment = new LineSegment(segmentType, segmentText);
        if (this.initialSegment == null) {
            this.initialSegment = newSegment;
            this.currentSegment = newSegment;
        } else {
            this.currentSegment.setNext(newSegment);
        }
        this.currentSegment = newSegment;
    }
}

