/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LineSegment
implements Iterable<LineSegment> {
    private static final List<String> RELATIONAL_OPERATORS = Arrays.asList("==", "!=", "<", ">", "<=", ">=", "equals");
    private static final List<String> CONDITIONAL_OPERATORS = Arrays.asList("||", "&&");
    private static final List<String> CONDITIONAL_INSTRUCTIONS = Arrays.asList("if", "for", "while");
    private final SegmentType type;
    private final String unformattedText;
    private final StringBuilder text;
    private final boolean containsConditionalOperator;
    private final boolean containsConditionalInstruction;
    private LineSegment next;

    LineSegment(SegmentType type, String text) {
        this.type = type;
        this.unformattedText = text.replaceAll("<", "&lt;");
        this.text = new StringBuilder(this.unformattedText);
        String trimmedText = text.trim();
        this.containsConditionalOperator = RELATIONAL_OPERATORS.contains(trimmedText) || CONDITIONAL_OPERATORS.contains(trimmedText);
        this.containsConditionalInstruction = CONDITIONAL_INSTRUCTIONS.contains(trimmedText);
    }

    boolean isCode() {
        return this.type == SegmentType.CODE;
    }

    boolean isComment() {
        return this.type == SegmentType.COMMENT;
    }

    boolean isSeparator() {
        return this.type == SegmentType.SEPARATOR;
    }

    boolean containsConditionalOperator() {
        return this.containsConditionalOperator;
    }

    static boolean isRelationalOperator(String source) {
        return RELATIONAL_OPERATORS.contains(source);
    }

    static boolean isConditionalOperator(String source) {
        return CONDITIONAL_OPERATORS.contains(source);
    }

    boolean containsConditionalInstruction() {
        return this.containsConditionalInstruction;
    }

    int getCharCount(char paren) {
        int count = 0;
        for (int p = 0; p < this.text.length(); ++p) {
            char c = this.text.charAt(p);
            if (c != paren) continue;
            ++count;
        }
        return count;
    }

    String getUnformattedText() {
        return this.unformattedText;
    }

    CharSequence getText() {
        return this.text;
    }

    void wrapBetween(String before, String after) {
        this.text.insert(0, before);
        this.text.append(after);
    }

    LineSegment getNext() {
        return this.next;
    }

    void setNext(LineSegment next) {
        this.next = next;
    }

    boolean before(LineSegment other) {
        for (LineSegment segmentAfter : this) {
            if (segmentAfter != other) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<LineSegment> iterator() {
        return new Iterator<LineSegment>(){
            private LineSegment current;
            {
                this.current = LineSegment.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public LineSegment next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                LineSegment next = this.current;
                this.current = this.current.next;
                return next;
            }

            @Override
            public void remove() {
            }
        };
    }

    public String toString() {
        StringBuilder line = new StringBuilder(200);
        for (LineSegment segment : this) {
            line.append((CharSequence)segment.text);
        }
        return line.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SegmentType {
        CODE,
        COMMENT,
        SEPARATOR;

    }
}

