/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.util.ArrayList;
import java.util.List;
import mockit.coverage.BranchCoverageData;
import mockit.coverage.CallPoint;
import mockit.coverage.LineCoverageData;
import mockit.coverage.reporting.LineSegment;
import mockit.coverage.reporting.ListOfCallPoints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LineSegmentsFormatter {
    private static final String EOL = System.getProperty("line.separator");
    private final boolean withCallPoints;
    private final StringBuilder formattedLine;

    LineSegmentsFormatter(boolean withCallPoints, StringBuilder formattedLine) {
        this.withCallPoints = withCallPoints;
        this.formattedLine = formattedLine;
    }

    void formatBranches(LineCoverageData lineData, LineSegment initialSegment) {
        LineSegment[][] segmentPairs = this.buildSegmentPairsForSourceElements(lineData.getSourceElements(), initialSegment);
        List<BranchCoverageData> branches = lineData.getBranches();
        FormattedSegments formattedSegments = this.buildFormattedSegments(lineData, branches, segmentPairs);
        formattedSegments.appendToFormattedLine();
    }

    private LineSegment[][] buildSegmentPairsForSourceElements(List<String> sourceElements, LineSegment initialSegment) {
        int pairCount = sourceElements.size();
        LineSegment[][] segmentPairs = new LineSegment[pairCount][2];
        LineSegment segment = initialSegment;
        for (int i = 0; segment != null && i < pairCount; segment = segment.getNext(), ++i) {
            String sourceElement = sourceElements.get(i);
            while (!this.sameSourceElement(segment, sourceElement)) {
                if (i > 0) {
                    segmentPairs[i - 1][1] = segment;
                }
                if ((segment = segment.getNext()) != null) continue;
                if (i < pairCount - 1) {
                    throw new IllegalStateException("Missing line segment for pair " + i);
                }
                return segmentPairs;
            }
            segmentPairs[i][0] = segment;
        }
        segmentPairs[0][0] = initialSegment;
        segmentPairs[pairCount - 1][1] = null;
        return segmentPairs;
    }

    private boolean sameSourceElement(LineSegment segment, String sourceElement) {
        return segment.isCode() && ("*".equals(sourceElement) || segment.getUnformattedText().equals(sourceElement) || ("if".equals(sourceElement) || LineSegment.isRelationalOperator(sourceElement)) && segment.containsConditionalOperator());
    }

    private FormattedSegments buildFormattedSegments(LineCoverageData lineData, List<BranchCoverageData> branches, LineSegment[][] segmentPairs) {
        FormattedSegments formattedSegments = new FormattedSegments();
        formattedSegments.addSegment(segmentPairs[0], lineData.getExecutionCount(), lineData.getCallPoints());
        for (BranchCoverageData branchData : branches) {
            LineSegment[] segmentPair;
            if (branchData.getJumpInsnIndex() > 0) {
                segmentPair = segmentPairs[branchData.getJumpInsnIndex()];
                formattedSegments.addSegment(segmentPair, lineData.getExecutionCount(), lineData.getCallPoints());
            }
            if (branchData.getNoJumpTargetInsnIndex() >= 0) {
                segmentPair = segmentPairs[branchData.getNoJumpTargetInsnIndex()];
                formattedSegments.addSegment(segmentPair, branchData.getNoJumpExecutionCount(), branchData.getNoJumpCallPoints());
            }
            if (branchData.getJumpTargetInsnIndex() < 0) continue;
            segmentPair = segmentPairs[branchData.getJumpTargetInsnIndex()];
            formattedSegments.addSegment(segmentPair, branchData.getJumpExecutionCount(), branchData.getJumpCallPoints());
        }
        formattedSegments.adjustPairsToIncludeAllLineSegments();
        return formattedSegments;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FormattedSegment {
        final LineSegment[] segmentPair;
        final int executionCount;
        final List<CallPoint> callPoints;

        FormattedSegment(LineSegment[] segmentPair, int executionCount, List<CallPoint> callPoints) {
            this.segmentPair = segmentPair;
            this.executionCount = executionCount;
            this.callPoints = callPoints;
        }

        void appendToFormattedLine() {
            this.appendStartTag();
            for (LineSegment segment : this.segmentPair[0]) {
                LineSegmentsFormatter.this.formattedLine.append(segment.getText());
                if (segment != this.segmentPair[1]) continue;
                break;
            }
            this.appendEndTag();
        }

        private void appendStartTag() {
            LineSegmentsFormatter.this.formattedLine.append("        <pre ");
            String startTagAttributes = LineSegmentsFormatter.this.withCallPoints && this.executionCount > 0 ? "onclick='showHide(this)' class='covered withCallPoints'>" : (this.executionCount > 0 ? "class='covered'>" : "class='uncovered'>");
            LineSegmentsFormatter.this.formattedLine.append(startTagAttributes);
        }

        private void appendEndTag() {
            LineSegmentsFormatter.this.formattedLine.append("</pre>").append(EOL);
            if (LineSegmentsFormatter.this.withCallPoints && this.executionCount > 0) {
                new ListOfCallPoints().insertListOfCallPoints(LineSegmentsFormatter.this.formattedLine, this.callPoints);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FormattedSegments {
        final List<FormattedSegment> segments = new ArrayList<FormattedSegment>();

        private FormattedSegments() {
        }

        void addSegment(LineSegment[] segmentPair, int executionCount, List<CallPoint> callPoints) {
            LineSegment newSegmentStart = segmentPair[0];
            int newSegmentIndex = this.segments.size();
            int i = 0;
            for (FormattedSegment segment : this.segments) {
                LineSegment segmentStart = segment.segmentPair[0];
                if (segmentStart == newSegmentStart) {
                    return;
                }
                if (newSegmentStart.before(segmentStart)) {
                    newSegmentIndex = i;
                    break;
                }
                ++i;
            }
            FormattedSegment segment = new FormattedSegment(segmentPair, executionCount, callPoints);
            this.segments.add(newSegmentIndex, segment);
        }

        void appendToFormattedLine() {
            for (FormattedSegment segment : this.segments) {
                segment.appendToFormattedLine();
            }
        }

        void adjustPairsToIncludeAllLineSegments() {
            int segmentCount = this.segments.size();
            for (int i = 0; i < segmentCount - 1; ++i) {
                LineSegment[] pair = this.segments.get((int)i).segmentPair;
                LineSegment[] nextPair = this.segments.get((int)(i + 1)).segmentPair;
                while (pair[1].getNext() != nextPair[0]) {
                    pair[1] = pair[1].getNext();
                }
            }
        }
    }
}

