/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.util.Arrays;
import java.util.List;
import mockit.coverage.reporting.LineSegment;

final class LineSyntaxFormatter {
    private static final List<String> JAVA_KEYWORDS = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "catch", "char", "class", "continue", "double", "do", "else", "extends", "false", "finally", "final", "float", "for", "if", "implements", "import", "interface", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "synchronized", "this", "throws", "throw", "true", "try", "void", "volatile", "while");

    LineSyntaxFormatter() {
    }

    void format(LineSegment initialSegment) {
        for (LineSegment lineSegment : initialSegment) {
            if (lineSegment.isCode()) {
                this.formatCodeSegment(lineSegment);
                continue;
            }
            if (!lineSegment.isComment()) continue;
            lineSegment.wrapBetween("<span class='comment'>", "</span>");
        }
    }

    private void formatCodeSegment(LineSegment segment) {
        if (JAVA_KEYWORDS.contains(((Object)segment.getText()).toString())) {
            segment.wrapBetween("<span class='keyword'>", "</span>");
        }
    }
}

