/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ListWithFilesAndPercentages {
    protected final PrintWriter output;
    private final int baseIndentationLevel;

    protected ListWithFilesAndPercentages(PrintWriter output, int baseIndentationLevel) {
        this.output = output;
        this.baseIndentationLevel = baseIndentationLevel;
    }

    protected abstract String getHRefToFile(String var1);

    protected abstract String getFileNameForDisplay(String var1);

    protected abstract void writeInternalTableForChildren(String var1);

    protected abstract int getCoveragePercentageForFile(String var1);

    final int writeMetricForEachFile(List<String> filePaths) {
        if (filePaths.isEmpty()) {
            return 0;
        }
        Collections.sort(filePaths);
        int percentageSum = 0;
        for (String filePath : filePaths) {
            this.printIndent(2);
            this.output.println("<tr>");
            this.printIndent(3);
            this.output.print("<td class='file'>");
            String href = this.getHRefToFile(filePath);
            if (href != null) {
                this.output.print("<a href='");
                this.output.print(href);
                this.output.print("'>");
            }
            this.output.print(this.getFileNameForDisplay(filePath));
            if (href != null) {
                this.output.print("</a>");
            }
            this.output.println("</td>");
            this.writeInternalTableForChildren(filePath);
            int filePercentage = this.getCoveragePercentageForFile(filePath);
            percentageSum += filePercentage;
            this.printIndent(3);
            this.output.print("<td class='coverage' style='background-color:#");
            this.output.print(this.percentageColor(filePercentage));
            this.output.print("'>");
            this.output.print(filePercentage);
            this.output.println("%</td>");
            this.printIndent(2);
            this.output.println("</tr>");
        }
        return percentageSum / filePaths.size();
    }

    private String percentageColor(int percentage) {
        if (percentage == 0) {
            return "ff0000";
        }
        if (percentage == 100) {
            return "00ff00";
        }
        int green = 255 * percentage / 100;
        int red = 255 - green;
        StringBuilder color = new StringBuilder(6);
        String hex = Integer.toHexString(red);
        if (hex.length() == 1) {
            color.append('0');
        }
        color.append(hex);
        hex = Integer.toHexString(green);
        if (hex.length() == 1) {
            color.append('0');
        }
        color.append(hex);
        color.append("00");
        return color.toString();
    }

    final void printIndent(int level) {
        for (int i = 0; i < this.baseIndentationLevel + level; ++i) {
            this.output.write("  ");
        }
    }
}

