/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.PrintWriter;
import java.util.Map;
import mockit.coverage.FileCoverageData;
import mockit.coverage.reporting.ListWithFilesAndPercentages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PackageCoverageReport
extends ListWithFilesAndPercentages {
    private final Map<String, FileCoverageData> filesToFileData;

    PackageCoverageReport(PrintWriter output, Map<String, FileCoverageData> filesToFileData) {
        super(output, 3);
        this.filesToFileData = filesToFileData;
    }

    @Override
    protected int getCoveragePercentageForFile(String filePath) {
        return this.filesToFileData.get(filePath).getCoveragePercentage();
    }

    @Override
    protected String getHRefToFile(String filePath) {
        return filePath.replace(".java", ".html");
    }

    @Override
    protected String getFileNameForDisplay(String filePath) {
        int p1 = filePath.lastIndexOf(47) + 1;
        int p2 = filePath.lastIndexOf(46);
        return (p2 > 0 ? filePath.substring(p1, p2) : filePath.substring(p1)) + ".java";
    }

    @Override
    protected void writeInternalTableForChildren(String filePath) {
    }
}

