/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import mockit.FullVerifications;
import mockit.FullVerificationsInOrder;
import mockit.Invocations;
import mockit.VerificationsInOrder;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.VerificationPhase;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verifications
extends Invocations {
    final VerificationPhase verificationPhase;

    protected Verifications() {
        this(false);
    }

    protected Verifications(int numberOfIterations) {
        this(false);
        this.verificationPhase.setNumberOfIterations(numberOfIterations);
    }

    Verifications(boolean inOrder) {
        RecordAndReplayExecution instance = TestRun.getExecutingTest().getRecordAndReplayForVerifications();
        Map<Type, Object> availableLocalMocks = instance.getLocalMocks();
        if (!availableLocalMocks.isEmpty()) {
            this.importMocksIntoLocalFields(this.getClass(), availableLocalMocks);
        }
        this.verificationPhase = instance.startVerifications(inOrder);
    }

    private void importMocksIntoLocalFields(Class<?> ownerClass, Map<Type, Object> localMocks) {
        Field[] fields;
        for (Field fieldToImport : fields = ownerClass.getDeclaredFields()) {
            if (Modifier.isFinal(fieldToImport.getModifiers())) continue;
            this.importMockIntoLocalField(localMocks, fieldToImport);
        }
        Class<?> superClass = ownerClass.getSuperclass();
        if (superClass != Verifications.class && superClass != VerificationsInOrder.class && superClass != FullVerifications.class && superClass != FullVerificationsInOrder.class) {
            this.importMocksIntoLocalFields(superClass, localMocks);
        }
    }

    private void importMockIntoLocalField(Map<Type, Object> localMocks, Field field) {
        Type mockedType = field.getGenericType();
        Object owner = localMocks.get(mockedType);
        if (owner != null) {
            Object mock = Utilities.getField(owner.getClass(), mockedType, owner);
            Utilities.setFieldValue(field, this, mock);
        }
    }

    @Override
    final VerificationPhase getCurrentPhase() {
        return this.verificationPhase;
    }
}

