/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.lang.reflect.Modifier;
import mockit.external.asm.ClassReader;
import mockit.external.asm.MethodVisitor;
import mockit.internal.BaseClassModifier;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.startup.Startup;
import mockit.internal.util.SuperConstructorCollector;

public final class StubOutModifier
extends BaseClassModifier {
    private final SuperConstructorCollector superConstructors = new SuperConstructorCollector(1);
    private final MockingConfiguration stubbingCfg;
    private String superClassName;

    public StubOutModifier(ClassReader cr, MockingConfiguration stubbingConfiguration) {
        super(cr);
        this.stubbingCfg = stubbingConfiguration;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superClassName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (Modifier.isAbstract(access) || (access & 0x1000) != 0 || Modifier.isNative(access) && !Startup.isJava6OrLater() || this.stubbingCfg != null && !this.stubbingCfg.matchesFilters(name, desc)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        if ("<init>".equals(name)) {
            this.generateCallToSuper();
        }
        this.generateEmptyImplementation(desc);
        return null;
    }

    private void generateCallToSuper() {
        this.mw.visitVarInsn(25, 0);
        String constructorDesc = this.superConstructors.findConstructor(this.superClassName);
        this.pushDefaultValuesForParameterTypes(constructorDesc);
        this.mw.visitMethodInsn(183, this.superClassName, "<init>", constructorDesc);
    }
}

