/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.List;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.VerificationPhase;
import mockit.internal.expectations.invocation.InvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UnorderedVerificationPhase
extends VerificationPhase {
    private Expectation aggregate;

    UnorderedVerificationPhase(RecordAndReplayExecution recordAndReplay, List<Expectation> expectationsInReplayOrder, List<Object[]> invocationArgumentsInReplayOrder) {
        super(recordAndReplay, expectationsInReplayOrder, invocationArgumentsInReplayOrder);
    }

    @Override
    protected void findNonStrictExpectation(Object mock, String mockClassDesc, String mockNameAndDesc, Object[] args) {
        this.aggregate = null;
        List<Expectation> expectations = this.getNonStrictExpectations();
        for (Expectation expectation : expectations) {
            if (!this.matches(mock, mockClassDesc, mockNameAndDesc, args, expectation)) continue;
            if (this.argMatchers == null) {
                this.currentExpectation = expectation;
                break;
            }
            this.aggregateMatchingExpectations(expectation);
        }
        if (this.currentExpectation != null) {
            this.currentExpectation.constraints.setLimits(this.numberOfIterations, -1);
            this.pendingError = this.currentExpectation.verifyConstraints();
        }
    }

    private void aggregateMatchingExpectations(Expectation found) {
        if (this.currentExpectation == null) {
            found.invocation.arguments.setMatchers(this.argMatchers);
            this.currentExpectation = found;
            return;
        }
        if (this.aggregate == null) {
            this.currentExpectation = this.aggregate = new Expectation(this.currentExpectation);
        }
        this.aggregate.constraints.addInvocationCount(found.constraints);
    }

    @Override
    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        Expectation expectation = this.getCurrentExpectation();
        expectation.constraints.setLimits(this.numberOfIterations * minInvocations, this.numberOfIterations * maxInvocations);
        this.pendingError = null;
        AssertionError error = expectation.verifyConstraints();
        if (error != null) {
            this.pendingError = error;
        }
    }

    @Override
    public void applyHandlerForEachInvocation(Object invocationHandler) {
        if (this.pendingError != null) {
            return;
        }
        this.getCurrentExpectation();
        InvocationHandler handler = new InvocationHandler(invocationHandler);
        int i = 0;
        int n = this.expectationsInReplayOrder.size();
        for (int j = 0; j < n; ++j) {
            Object[] args;
            Expectation expectation = (Expectation)this.expectationsInReplayOrder.get(j);
            if (!this.evaluateInvocationHandlerIfExpectationMatchesCurrent(expectation, args = (Object[])this.invocationArgumentsInReplayOrder.get(j), handler, i)) continue;
            ++i;
        }
    }
}

