/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import mockit.internal.expectations.invocation.ExpectedInvocation;

public final class InvocationConstraints {
    public int minInvocations;
    int maxInvocations;
    public int invocationCount;

    public InvocationConstraints(boolean nonStrictInvocation) {
        this.setDefaultLimits(nonStrictInvocation);
    }

    public InvocationConstraints(InvocationConstraints other) {
        this.setLimits(other.minInvocations, other.maxInvocations);
        this.invocationCount = other.invocationCount;
    }

    public void setDefaultLimits(boolean nonStrictInvocation) {
        this.setLimits(nonStrictInvocation ? 0 : 1, nonStrictInvocation ? -1 : 1);
    }

    public void setLimits(int minInvocations, int maxInvocations) {
        this.minInvocations = minInvocations;
        this.maxInvocations = maxInvocations;
    }

    void adjustMaxInvocations(int expectedInvocationCount) {
        if (this.maxInvocations > 0 && this.maxInvocations < expectedInvocationCount) {
            this.maxInvocations = expectedInvocationCount;
        }
    }

    void setUnlimitedMaxInvocations() {
        this.maxInvocations = -1;
    }

    public boolean incrementInvocationCount() {
        ++this.invocationCount;
        return this.invocationCount == this.maxInvocations;
    }

    public void addInvocationCount(InvocationConstraints other) {
        this.invocationCount += other.invocationCount;
    }

    public boolean isInvocationCountLessThanMinimumExpected() {
        return this.invocationCount < this.minInvocations;
    }

    public boolean isInvocationCountMoreThanMaximumExpected() {
        return this.maxInvocations >= 0 && this.invocationCount > this.maxInvocations;
    }

    public boolean isInvocationCountInExpectedRange() {
        return this.minInvocations <= this.invocationCount && (this.invocationCount <= this.maxInvocations || this.maxInvocations < 0);
    }

    public AssertionError verify(ExpectedInvocation invocation) {
        AssertionError error = this.verifyLowerLimit(invocation);
        return error != null ? error : this.verifyUpperLimit(invocation);
    }

    private AssertionError verifyLowerLimit(ExpectedInvocation invocation) {
        return this.invocationCount < this.minInvocations ? this.errorForMissingExpectations(invocation) : null;
    }

    public AssertionError errorForMissingExpectations(ExpectedInvocation invocation) {
        return invocation.errorForMissingInvocations(this.minInvocations - this.invocationCount);
    }

    private AssertionError verifyUpperLimit(ExpectedInvocation invocation) {
        int n;
        if (this.maxInvocations >= 0 && (n = this.invocationCount - this.maxInvocations) > 0) {
            return invocation.errorForUnexpectedInvocations(n);
        }
        return null;
    }
}

