/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Constructor;
import mockit.internal.expectations.mocking.MockConstructorInfo;
import mockit.internal.util.Utilities;

public interface InstanceFactory {
    public Object create();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumInstanceFactory
    implements InstanceFactory {
        private final Object anEnumValue;

        EnumInstanceFactory(Class<?> enumClass) {
            this.anEnumValue = enumClass.getEnumConstants()[0];
        }

        @Override
        public Object create() {
            return this.anEnumValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ConcreteClassInstanceFactory
    implements InstanceFactory {
        private final Class<?> concreteClass;
        private final String constructorDesc;

        ConcreteClassInstanceFactory(Class<?> concreteClass, String constructorDesc) {
            this.concreteClass = concreteClass;
            this.constructorDesc = constructorDesc;
        }

        @Override
        public Object create() {
            Object[] initArgs = null;
            if (this.constructorDesc == null) {
                Constructor<?> constructor = this.concreteClass.getDeclaredConstructors()[0];
                return Utilities.invoke(constructor, initArgs);
            }
            Class<?>[] constructorParamTypes = Utilities.getParameterTypes(this.constructorDesc);
            return Utilities.newInstance(this.concreteClass, constructorParamTypes, initArgs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AbstractClassInstanceFactory
    implements InstanceFactory {
        private final MockConstructorInfo mockConstructorInfo;
        private final Class<?> subclass;

        AbstractClassInstanceFactory(MockConstructorInfo mockConstructorInfo, Class<?> subclass) {
            this.mockConstructorInfo = mockConstructorInfo;
            this.subclass = subclass;
        }

        @Override
        public Object create() {
            if (this.mockConstructorInfo != null) {
                return this.mockConstructorInfo.newInstance(this.subclass);
            }
            Constructor<?> constructor = this.subclass.getDeclaredConstructors()[0];
            return Utilities.invoke(constructor, new Object[0]);
        }
    }

    public static final class InterfaceInstanceFactory
    implements InstanceFactory {
        private final Object emptyProxy;

        InterfaceInstanceFactory(Object emptyProxy) {
            this.emptyProxy = emptyProxy;
        }

        public Object create() {
            return this.emptyProxy;
        }
    }
}

