/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.invocation.MockedTypeCascade;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutingTest {
    private RecordAndReplayExecution currentRecordAndReplay;
    private RecordAndReplayExecution recordAndReplayForLastTestMethod;
    private boolean shouldIgnoreMockingCallbacks;
    private ParameterTypeRedefinitions parameterTypeRedefinitions;
    private final List<Object> nonStrictMocks = new ArrayList<Object>();
    private final List<Object> strictMocks = new ArrayList<Object>();
    private final Map<String, MockedTypeCascade> cascadingTypes = new HashMap<String, MockedTypeCascade>();

    RecordAndReplayExecution getRecordAndReplay(boolean createIfUndefined) {
        if (this.currentRecordAndReplay == null && createIfUndefined) {
            this.setUpNewRecordAndReplay();
        }
        return this.currentRecordAndReplay;
    }

    private void setUpNewRecordAndReplay() {
        RecordAndReplayExecution previous = this.setRecordAndReplay(null);
        this.setRecordAndReplay(new RecordAndReplayExecution(previous));
    }

    public RecordAndReplayExecution setRecordAndReplay(RecordAndReplayExecution newRecordAndReplay) {
        this.recordAndReplayForLastTestMethod = null;
        RecordAndReplayExecution previous = this.currentRecordAndReplay;
        this.currentRecordAndReplay = newRecordAndReplay;
        return previous;
    }

    public boolean isShouldIgnoreMockingCallbacks() {
        return this.shouldIgnoreMockingCallbacks;
    }

    public void setShouldIgnoreMockingCallbacks(boolean flag) {
        this.shouldIgnoreMockingCallbacks = flag;
    }

    public void clearRecordAndReplayForVerifications() {
        this.recordAndReplayForLastTestMethod = null;
    }

    public RecordAndReplayExecution getRecordAndReplayForVerifications() {
        if (this.currentRecordAndReplay != null) {
            return this.currentRecordAndReplay;
        }
        if (this.recordAndReplayForLastTestMethod != null) {
            this.currentRecordAndReplay = this.recordAndReplayForLastTestMethod;
            return this.recordAndReplayForLastTestMethod;
        }
        this.setUpNewRecordAndReplay();
        return this.currentRecordAndReplay;
    }

    public ParameterTypeRedefinitions getParameterTypeRedefinitions() {
        return this.parameterTypeRedefinitions;
    }

    public void setParameterTypeRedefinitions(ParameterTypeRedefinitions redefinitions) {
        this.parameterTypeRedefinitions = redefinitions;
        this.addNonStrictMocks(redefinitions.getNonStrictMocks());
    }

    public void addNonStrictMock(Class<?> mockedClass) {
        String mockedClassDesc = mockedClass.getName().replace('.', '/');
        String uniqueClassDesc = mockedClassDesc.intern();
        if (!this.containsNonStrictMockedClass(uniqueClassDesc)) {
            this.nonStrictMocks.add(uniqueClassDesc);
        }
    }

    private boolean containsNonStrictMockedClass(String classDesc) {
        for (Object mockClassDesc : this.nonStrictMocks) {
            if (classDesc != mockClassDesc) continue;
            return true;
        }
        return false;
    }

    public void addNonStrictMock(Object mock) {
        this.nonStrictMocks.add(mock);
        if (!(mock instanceof Proxy)) {
            Class<?> mockedClass = mock.getClass();
            String mockedClassDesc = mockedClass.getName().replace('.', '/');
            this.nonStrictMocks.add(mockedClassDesc.intern());
        }
    }

    public void addNonStrictMocks(List<Object> mocks) {
        for (Object mock : mocks) {
            this.addNonStrictMock(mock);
        }
    }

    public void addStrictMock(Object mock, String mockClassDesc) {
        String uniqueMockClassDesc;
        this.addStrictMock(mock);
        if (mockClassDesc != null && !this.containsStrictMock(uniqueMockClassDesc = mockClassDesc.intern()) && !this.containsNonStrictMockedClass(uniqueMockClassDesc)) {
            this.strictMocks.add(uniqueMockClassDesc);
        }
    }

    private void addStrictMock(Object mock) {
        if (mock != null && !this.containsStrictMock(mock)) {
            this.strictMocks.add(mock);
        }
    }

    private boolean containsStrictMock(Object mockOrClass) {
        for (Object strictMock : this.strictMocks) {
            if (mockOrClass != strictMock) continue;
            return true;
        }
        return false;
    }

    public boolean containsNonStrictMock(int access, Object mock, String mockClassDesc, String mockNameAndDesc) {
        boolean staticMethod = Modifier.isStatic(access);
        boolean constructor = !staticMethod && mockNameAndDesc.startsWith("<init>");
        for (Object nonStrictMock : this.nonStrictMocks) {
            if (!(staticMethod || constructor ? nonStrictMock == mockClassDesc : nonStrictMock == mock)) continue;
            return true;
        }
        return false;
    }

    public boolean containsStrictMockForRunningTest(Object mock, String mockClassDesc) {
        for (Object strictMock : this.strictMocks) {
            if (strictMock == mock) {
                return true;
            }
            if (strictMock != mockClassDesc) continue;
            this.addStrictMock(mock);
            return true;
        }
        return false;
    }

    public void substituteMock(Object previousInstance, Object newInstance) {
        for (Object strictMock : this.strictMocks) {
            if (strictMock != previousInstance) continue;
            this.strictMocks.add(newInstance);
            return;
        }
    }

    public void clearNonStrictMocks() {
        this.nonStrictMocks.clear();
    }

    public Map<String, MockedTypeCascade> getCascadingMockedTypes() {
        return this.cascadingTypes;
    }

    public void addCascadingType(String mockedTypeDesc) {
        if (!this.cascadingTypes.containsKey(mockedTypeDesc)) {
            this.cascadingTypes.put(mockedTypeDesc, new MockedTypeCascade());
        }
    }

    public MockedTypeCascade getMockedTypeCascade(String mockedTypeDesc, Object mockInstance) {
        if (this.cascadingTypes.isEmpty()) {
            return null;
        }
        MockedTypeCascade cascade = this.cascadingTypes.get(mockedTypeDesc);
        if (cascade != null || mockInstance == null) {
            return cascade;
        }
        return this.getMockedTypeCascade(mockedTypeDesc, mockInstance.getClass());
    }

    private MockedTypeCascade getMockedTypeCascade(String invokedTypeDesc, Class<?> mockedType) {
        Class<?> typeToLookFor = mockedType;
        do {
            String typeDesc;
            if (invokedTypeDesc.equals(typeDesc = typeToLookFor.getName().replace('.', '/'))) {
                return null;
            }
            MockedTypeCascade cascade = this.cascadingTypes.get(typeDesc);
            if (cascade == null) continue;
            return cascade;
        } while ((typeToLookFor = typeToLookFor.getSuperclass()) != Object.class);
        return null;
    }

    void finishExecution() {
        this.recordAndReplayForLastTestMethod = this.currentRecordAndReplay;
        this.currentRecordAndReplay = null;
        if (this.parameterTypeRedefinitions != null) {
            this.parameterTypeRedefinitions.cleanUp();
            this.parameterTypeRedefinitions = null;
        }
        this.nonStrictMocks.clear();
        this.strictMocks.clear();
        this.cascadingTypes.clear();
    }
}

