/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.util.HashSet;
import java.util.Set;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SavePoint {
    private static SavePoint savePointForTestClass;
    private final Set<String> previousTransformedClasses = this.getCopyOfAllTransformedClasses();
    private final Set<Class<?>> previousRedefinedClasses = this.getCopyOfAllRedefinedClasses();
    private final int previousMockInstancesCount = TestRun.getMockClasses().getRegularMocks().getInstanceCount();

    private Set<String> getCopyOfAllTransformedClasses() {
        return new HashSet<String>(TestRun.mockFixture().getTransformedClasses());
    }

    private Set<Class<?>> getCopyOfAllRedefinedClasses() {
        return new HashSet(TestRun.mockFixture().getRedefinedClasses());
    }

    public void rollback() {
        this.restoreClassesTransformedAfterSavepoint();
        this.restoreClassesRedefinedAfterSavepoint();
        TestRun.getMockClasses().getRegularMocks().removeInstances(this.previousMockInstancesCount);
    }

    private void restoreClassesTransformedAfterSavepoint() {
        Set<String> classesToRestore = this.getCopyOfAllTransformedClasses();
        classesToRestore.removeAll(this.previousTransformedClasses);
        if (!classesToRestore.isEmpty()) {
            TestRun.mockFixture().restoreAndRemoveTransformedClasses(classesToRestore);
        }
    }

    private void restoreClassesRedefinedAfterSavepoint() {
        Set<Class<Class<?>>> classesToRestore = this.getCopyOfAllRedefinedClasses();
        classesToRestore.removeAll(this.previousRedefinedClasses);
        if (!classesToRestore.isEmpty()) {
            TestRun.mockFixture().restoreAndRemoveRedefinedClasses(classesToRestore);
        }
    }

    public static void registerNewActiveSavePoint() {
        savePointForTestClass = new SavePoint();
    }

    public static void rollbackForTestClass() {
        if (savePointForTestClass != null) {
            savePointForTestClass.rollback();
            savePointForTestClass = null;
        }
    }
}

