/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import mockit.external.asm.Type;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultValues {
    private static final Map<String, Object> TYPE_DESC_TO_VALUE_MAP = new HashMap<String, Object>(){
        {
            this.put("Z", false);
            this.put("C", Character.valueOf('\u0000'));
            this.put("B", (byte)0);
            this.put("S", (short)0);
            this.put("I", 0);
            this.put("F", Float.valueOf(0.0f));
            this.put("J", 0L);
            this.put("D", 0.0);
            this.put("Ljava/util/Collection;", Collections.emptyList());
            this.put("Ljava/util/List;", Collections.emptyList());
            this.put("Ljava/util/Set;", Collections.emptySet());
            this.put("Ljava/util/SortedSet;", Collections.unmodifiableSortedSet(new TreeSet()));
            this.put("Ljava/util/Map;", Collections.emptyMap());
            this.put("Ljava/util/SortedMap;", Collections.unmodifiableSortedMap(new TreeMap()));
        }
    };
    private static final Map<String, Object> ELEM_TYPE_TO_ONE_D_ARRAY = new HashMap<String, Object>(){
        {
            this.put("[Z", new boolean[0]);
            this.put("[C", new char[0]);
            this.put("[B", new byte[0]);
            this.put("[S", new short[0]);
            this.put("[I", new int[0]);
            this.put("[F", new float[0]);
            this.put("[J", new long[0]);
            this.put("[D", new double[0]);
            this.put("[Ljava/lang/Object;", new Object[0]);
            this.put("[Ljava/lang/String;", new String[0]);
        }
    };

    private DefaultValues() {
    }

    public static Object computeForReturnType(String methodNameAndDesc) {
        String typeDesc = DefaultValues.getReturnTypeDesc(methodNameAndDesc);
        return DefaultValues.computeForType(typeDesc);
    }

    public static String getReturnTypeDesc(String methodNameAndDesc) {
        int rightParen = methodNameAndDesc.indexOf(41) + 1;
        return methodNameAndDesc.substring(rightParen);
    }

    public static Object computeForType(String typeDesc) {
        char typeDescChar = typeDesc.charAt(0);
        if (typeDescChar == 'V') {
            return null;
        }
        Object defaultValue = TYPE_DESC_TO_VALUE_MAP.get(typeDesc);
        if (defaultValue != null) {
            return defaultValue;
        }
        if (typeDescChar == 'L') {
            return null;
        }
        Object emptyArray = ELEM_TYPE_TO_ONE_D_ARRAY.get(typeDesc);
        if (emptyArray == null) {
            emptyArray = DefaultValues.newEmptyArray(typeDesc);
        }
        return emptyArray;
    }

    private static Object newEmptyArray(String typeDesc) {
        Type type = Type.getType(typeDesc);
        Class<?> elementType = Utilities.getClassForType(type.getElementType());
        return Array.newInstance(elementType, new int[type.getDimensions()]);
    }

    public static Object computeForType(Class<?> type) {
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        if (type != Void.TYPE && type.isPrimitive()) {
            return DefaultValues.defaultValueForPrimitiveType(type);
        }
        return null;
    }

    private static Object defaultValueForPrimitiveType(Class<?> type) {
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        return (short)0;
    }
}

