/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.io;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationSegment;
import com.mockobjects.Verifiable;
import com.mockobjects.util.Verifier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class MockPrintWriter
extends PrintWriter
implements Verifiable {
    private ExpectationSegment mySegment = new ExpectationSegment("String segment");
    private ExpectationCounter myCloseCalls = new ExpectationCounter("close calls");
    private ExpectationCounter myFlushCalls = new ExpectationCounter("flush calls");

    public MockPrintWriter() {
        this(new StringWriter());
    }

    private MockPrintWriter(Writer writer) {
        super(writer);
    }

    public void setExpectedCloseCalls(int calls) {
        this.myCloseCalls.setExpected(calls);
    }

    public void setExpectedSegment(String aString) {
        this.mySegment.setExpected(aString);
    }

    public void write(String s) {
        super.write(s);
        this.mySegment.setActual(s);
    }

    public void setExpectedFlushCalls(int calls) {
        this.myFlushCalls.setExpected(calls);
    }

    public void flush() {
        super.flush();
        this.myFlushCalls.inc();
    }

    public void close() {
        super.close();
        this.myCloseCalls.inc();
    }

    public void verify() {
        Verifier.verifyObject((Object)this);
    }
}

