/*
 * Decompiled with CFR 0.152.
 */
package moe.dare.briareus.api;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import moe.dare.briareus.api.FileSource;

public final class FileEntry {
    private static final String PORTABLE_FILENAME_REGEX = "^[a-zA-Z0-9_.-]*[a-zA-Z0-9_-]$";
    private static final Predicate<String> VALID_PATH_PREDICATE = Pattern.compile("^[a-zA-Z0-9_.-]*[a-zA-Z0-9_-]$").asPredicate();
    private final String name;
    private final FileSource fileSource;
    private final Mode mode;

    public static FileEntry copy(FileSource fileSource, String name) {
        return new FileEntry(fileSource, name, Mode.COPY);
    }

    public static FileEntry unzip(FileSource fileSource, String name) {
        return new FileEntry(fileSource, name, Mode.UNZIP);
    }

    public FileSource source() {
        return this.fileSource;
    }

    public String name() {
        return this.name;
    }

    public Mode mode() {
        return this.mode;
    }

    private FileEntry(FileSource fileSource, String name, Mode mode) {
        this.fileSource = Objects.requireNonNull(fileSource, "file source");
        this.name = Objects.requireNonNull(name, "file entry name");
        this.mode = Objects.requireNonNull(mode, "file entry mode");
        if (!VALID_PATH_PREDICATE.test(name)) {
            throw new IllegalArgumentException("Bad file entry name: " + name);
        }
    }

    public static enum Mode {
        COPY,
        UNZIP;

    }
}

