/*
 * Decompiled with CFR 0.152.
 */
package moe.dare.briareus.api;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import moe.dare.briareus.api.CacheableFileSource;
import moe.dare.briareus.api.FileSource;

public class FileSources {
    private FileSources() {
    }

    public static FileSource classpathSource(ClassLoader classLoader, String resourceName) {
        if (classLoader.getResource(resourceName) == null) {
            throw new IllegalArgumentException("No resource named " + resourceName + " in " + classLoader);
        }
        return new ClasspathSource(classLoader, resourceName);
    }

    public static FileSource fileSource(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + path + " dose not exists");
        }
        return new FilePathSource(path);
    }

    private static final class ClasspathSource
    implements CacheableFileSource {
        private final ClassLoader classLoader;
        private final String resourceName;

        private ClasspathSource(ClassLoader classLoader, String resourceName) {
            this.classLoader = Objects.requireNonNull(classLoader, "Classloader");
            this.resourceName = Objects.requireNonNull(resourceName, "resource name");
        }

        @Override
        public InputStream open() throws IOException {
            InputStream stream = this.classLoader.getResourceAsStream(this.resourceName);
            if (stream == null) {
                throw new IOException("No classpath resource [" + this.resourceName + "] in classloader " + this.classLoader);
            }
            return stream;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClasspathSource that = (ClasspathSource)o;
            if (!this.classLoader.equals(that.classLoader)) {
                return false;
            }
            return this.resourceName.equals(that.resourceName);
        }

        public int hashCode() {
            int result = this.classLoader.hashCode();
            result = 31 * result + this.resourceName.hashCode();
            return result;
        }
    }

    private static final class FilePathSource
    implements CacheableFileSource {
        private final Path path;

        private FilePathSource(Path path) {
            this.path = Objects.requireNonNull(path, "path");
        }

        @Override
        public InputStream open() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public Optional<Path> file() {
            return Optional.of(this.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilePathSource that = (FilePathSource)o;
            return this.path.equals(that.path);
        }
    }
}

