/*
 * Decompiled with CFR 0.152.
 */
package moe.dare.briareus.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import moe.dare.briareus.api.FileEntry;
import moe.dare.briareus.api.OptKey;
import org.jetbrains.annotations.Nullable;

public class RemoteJvmOptions {
    private static final String VALID_ENVIRONMENT_VARIABLE_NAME_REGEX = "^[A-Z_]+[A-Z0-9_]*$";
    private static final Predicate<String> VALID_ENVIRONMENT_VARIABLE_NAME_PREDICATE = Pattern.compile("^[A-Z_]+[A-Z0-9_]*$").asPredicate();
    private final List<FileEntry> files;
    private final Map<String, String> environment;
    private final List<String> classpath;
    private final List<String> vmOptions;
    @Nullable
    private final Long maxHeapSize;
    private final String mainClass;
    private final List<String> arguments;
    private final Map<OptKey<?>, Object> opts;

    public static RemoteJvmOptionsBuilder newBuilder() {
        return new RemoteJvmOptionsBuilder();
    }

    private RemoteJvmOptions(RemoteJvmOptionsBuilder builder) {
        this.files = RemoteJvmOptions.toUnmodifiableList(builder.files);
        this.environment = RemoteJvmOptions.toUnmodifiableMap(builder.environmentKeys, builder.environmentValues);
        this.classpath = RemoteJvmOptions.toUnmodifiableList(builder.classpath);
        this.vmOptions = RemoteJvmOptions.toUnmodifiableList(builder.vmOptions);
        this.maxHeapSize = builder.maxHeapSize;
        this.mainClass = Objects.requireNonNull(builder.mainClass, "builder.mainClass");
        this.arguments = RemoteJvmOptions.toUnmodifiableList(builder.arguments);
        this.opts = RemoteJvmOptions.toUnmodifiableMap(builder.optKeys, builder.optValues);
    }

    public RemoteJvmOptionsBuilder toBuilder() {
        return new RemoteJvmOptionsBuilder(this);
    }

    public List<FileEntry> files() {
        return this.files;
    }

    public Map<String, String> environmentOverrides() {
        return this.environment;
    }

    public List<String> classpath() {
        return this.classpath;
    }

    public List<String> vmOptions() {
        return this.vmOptions;
    }

    public OptionalLong maxHeapSize() {
        return this.maxHeapSize == null ? OptionalLong.empty() : OptionalLong.of(this.maxHeapSize);
    }

    public String mainClass() {
        return this.mainClass;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public <T> Optional<T> getOpt(OptKey<T> optKey) {
        Object value = this.opts.get(optKey);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(optKey.cast(value));
    }

    private static <K, V> Map<K, V> toUnmodifiableMap(List<K> keys, List<V> values) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (keys.size() == 1) {
            return Collections.singletonMap(keys.get(0), values.get(0));
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return Collections.unmodifiableMap(map);
    }

    private static <T> List<T> toUnmodifiableList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static class RemoteJvmOptionsBuilder {
        private final List<FileEntry> files = new ArrayList<FileEntry>();
        private final List<String> environmentKeys = new ArrayList<String>();
        private final List<String> environmentValues = new ArrayList<String>();
        private final List<String> classpath = new ArrayList<String>();
        private final List<String> vmOptions = new ArrayList<String>();
        private final List<String> arguments = new ArrayList<String>();
        private final List<OptKey<?>> optKeys = new ArrayList();
        private final List<Object> optValues = new ArrayList<Object>();
        @Nullable
        private Long maxHeapSize;
        @Nullable
        private String mainClass;

        private RemoteJvmOptionsBuilder() {
        }

        private RemoteJvmOptionsBuilder(RemoteJvmOptions jvmOptions) {
            this.addFiles(jvmOptions.files);
            this.addEnvironment(jvmOptions.environment);
            this.addClasspath(jvmOptions.classpath);
            this.addVmOptions(jvmOptions.vmOptions);
            this.addArguments(jvmOptions.arguments);
            this.maxHeapSize(jvmOptions.maxHeapSize);
            this.mainClass(jvmOptions.mainClass);
            RemoteJvmOptionsBuilder.addMapInto(jvmOptions.opts, this.optKeys, this.optValues);
        }

        public RemoteJvmOptions build() {
            if (this.mainClass == null) {
                throw new IllegalStateException("Main class not set");
            }
            return new RemoteJvmOptions(this);
        }

        public RemoteJvmOptionsBuilder addFile(FileEntry file) {
            this.validateFileEntry(file);
            this.files.add(file);
            return this;
        }

        public RemoteJvmOptionsBuilder addFiles(Collection<? extends FileEntry> files) {
            Objects.requireNonNull(files, "files");
            ArrayList<FileEntry> appendableFiles = new ArrayList<FileEntry>(files);
            this.validateFiles(appendableFiles);
            this.files.addAll(appendableFiles);
            return this;
        }

        public RemoteJvmOptionsBuilder setFiles(Collection<? extends FileEntry> files) {
            Objects.requireNonNull(files, "files");
            ArrayList<FileEntry> appendableFiles = new ArrayList<FileEntry>(files);
            this.validateFiles(appendableFiles);
            this.files.clear();
            this.files.addAll(appendableFiles);
            return this;
        }

        public RemoteJvmOptionsBuilder addEnvironment(String key, String value) {
            this.validateEnvironmentEntry(key, value);
            this.environmentKeys.add(key);
            this.environmentValues.add(value);
            return this;
        }

        public RemoteJvmOptionsBuilder addEnvironment(Map<String, String> environment) {
            Objects.requireNonNull(environment, "environment");
            LinkedHashMap<String, String> appendEnvironment = new LinkedHashMap<String, String>(environment);
            this.validateEnvironment(appendEnvironment);
            RemoteJvmOptionsBuilder.addMapInto(environment, this.environmentKeys, this.environmentValues);
            return this;
        }

        public RemoteJvmOptionsBuilder setEnvironment(Map<String, String> environment) {
            Objects.requireNonNull(environment, "environment");
            LinkedHashMap<String, String> appendEnvironment = new LinkedHashMap<String, String>(environment);
            this.validateEnvironment(appendEnvironment);
            this.environmentKeys.clear();
            this.environmentValues.clear();
            RemoteJvmOptionsBuilder.addMapInto(environment, this.environmentKeys, this.environmentValues);
            return this;
        }

        public RemoteJvmOptionsBuilder addClasspath(String classpathEntry) {
            this.validateClasspathEntry(classpathEntry);
            this.classpath.add(classpathEntry);
            return this;
        }

        public RemoteJvmOptionsBuilder addClasspath(Collection<String> classpath) {
            Objects.requireNonNull(classpath, "classpath");
            ArrayList<String> appendClasspath = new ArrayList<String>(classpath);
            this.validateClasspath(appendClasspath);
            this.classpath.addAll(appendClasspath);
            return this;
        }

        public RemoteJvmOptionsBuilder setClasspath(Collection<String> classpath) {
            Objects.requireNonNull(classpath, "classpath");
            ArrayList<String> appendClasspath = new ArrayList<String>(classpath);
            this.validateClasspath(appendClasspath);
            this.classpath.clear();
            this.classpath.addAll(appendClasspath);
            return this;
        }

        public RemoteJvmOptionsBuilder addVmOption(String vmOption) {
            this.validateVmOption(vmOption);
            this.vmOptions.add(vmOption);
            return this;
        }

        public RemoteJvmOptionsBuilder addVmOptions(Collection<String> vmOptions) {
            Objects.requireNonNull(vmOptions, "vmOptions");
            ArrayList<String> appendVmOptions = new ArrayList<String>(vmOptions);
            this.validateVmOptions(appendVmOptions);
            this.vmOptions.addAll(appendVmOptions);
            return this;
        }

        public RemoteJvmOptionsBuilder setVmOptions(Collection<String> vmOptions) {
            Objects.requireNonNull(vmOptions, "vmOptions");
            ArrayList<String> appendVmOptions = new ArrayList<String>(vmOptions);
            this.validateVmOptions(appendVmOptions);
            this.vmOptions.clear();
            this.vmOptions.addAll(appendVmOptions);
            return this;
        }

        public RemoteJvmOptionsBuilder maxHeapSize(Long bytes) {
            this.validateMaxHeapSize(bytes);
            this.maxHeapSize = bytes;
            return this;
        }

        public RemoteJvmOptionsBuilder mainClass(String className) {
            this.validateMainClass(className);
            this.mainClass = className;
            return this;
        }

        public RemoteJvmOptionsBuilder mainClass(Class<?> clazz) {
            return this.mainClass(clazz.getName());
        }

        public RemoteJvmOptionsBuilder addArgument(String argument) {
            this.validateArgument(argument);
            this.arguments.add(argument);
            return this;
        }

        public RemoteJvmOptionsBuilder addArguments(Collection<String> arguments) {
            Objects.requireNonNull(arguments, "arguments");
            ArrayList<String> appendArguments = new ArrayList<String>(arguments);
            this.validateArguments(appendArguments);
            this.arguments.addAll(appendArguments);
            return this;
        }

        public RemoteJvmOptionsBuilder setArguments(List<String> arguments) {
            Objects.requireNonNull(arguments, "arguments");
            ArrayList<String> appendArguments = new ArrayList<String>(arguments);
            this.validateArguments(appendArguments);
            this.arguments.clear();
            this.arguments.addAll(appendArguments);
            return this;
        }

        public <T> RemoteJvmOptionsBuilder opt(OptKey<T> optKey, T optValue) {
            Objects.requireNonNull(optKey, "optKey");
            Objects.requireNonNull(optValue, "optValue");
            optKey.validate(optValue);
            this.optKeys.add(optKey);
            this.optValues.add(optValue);
            return this;
        }

        private void validateFiles(List<FileEntry> files) {
            files.forEach(this::validateFileEntry);
        }

        private void validateFileEntry(FileEntry fileEntry) {
            Objects.requireNonNull(fileEntry, "file entry");
        }

        private void validateEnvironment(Map<String, String> overrides) {
            overrides.forEach(this::validateEnvironmentEntry);
        }

        private void validateEnvironmentEntry(String name, String value) {
            Objects.requireNonNull(name, "Environment variable name");
            Objects.requireNonNull(value, "Environment variable value");
            if (!VALID_ENVIRONMENT_VARIABLE_NAME_PREDICATE.test(name)) {
                throw new IllegalArgumentException("Bad environment variable name: " + name);
            }
        }

        private void validateClasspath(List<String> classpath) {
            for (String s : classpath) {
                this.validateClasspathEntry(s);
            }
        }

        private void validateClasspathEntry(String classpathEntry) {
            Objects.requireNonNull(classpathEntry, "Classpath entry");
        }

        private void validateVmOptions(List<String> vmOptions) {
            for (String entry : vmOptions) {
                this.validateVmOption(entry);
            }
        }

        private void validateVmOption(String vmOption) {
            Objects.requireNonNull(vmOption, "VM option");
        }

        private void validateArguments(List<String> arguments) {
            for (String entry : arguments) {
                this.validateArgument(entry);
            }
        }

        private void validateArgument(String argument) {
            Objects.requireNonNull(argument, "JVM argument");
        }

        private void validateMaxHeapSize(Long bytes) {
            if (bytes != null && bytes <= 0L) {
                throw new IllegalArgumentException("Bad heap size: " + bytes);
            }
        }

        private void validateMainClass(String mainClass) {
            Objects.requireNonNull(mainClass, "main class name");
        }

        private static <K, V> void addMapInto(Map<K, V> map, List<K> keys, List<V> values) {
            map.forEach((k, v) -> {
                keys.add(k);
                values.add(v);
            });
        }
    }
}

