/*
 * Decompiled with CFR 0.152.
 */
import Config.EncoderConfig;
import com.luciad.imageio.webp.WebPWriteParam;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class WebpEncoder {
    public static void encode(String originImagePath, String webpImagePath) throws IOException {
        BufferedImage image = ImageIO.read(new File(originImagePath));
        ImageWriter writer = ImageIO.getImageWritersByMIMEType("image/webp").next();
        WebPWriteParam writeParam = new WebPWriteParam(writer.getLocale());
        writeParam.setCompressionMode(1);
        writer.setOutput(new FileImageOutputStream(new File(webpImagePath)));
        writer.write(null, new IIOImage(image, null, null), (ImageWriteParam)writeParam);
    }

    public static void encode(String originImagePath, String webpImagePath, EncoderConfig config) throws IOException {
        BufferedImage image = ImageIO.read(new File(originImagePath));
        ImageWriter writer = ImageIO.getImageWritersByMIMEType("image/webp").next();
        WebPWriteParam writeParam = new WebPWriteParam(writer.getLocale());
        if (config.getCompressionMode() == 2) {
            writeParam.setCompressionMode(config.getCompressionMode());
            writeParam.setCompressionType(writeParam.getCompressionTypes()[config.getCompressionType()]);
            writeParam.setCompressionQuality(config.getCompressionQuality());
        }
        writeParam.setCompressionMode(config.getCompressionMode());
        writer.setOutput(new FileImageOutputStream(new File(webpImagePath)));
        writer.write(null, new IIOImage(image, null, null), (ImageWriteParam)writeParam);
    }
}

