/*
 * Decompiled with CFR 0.152.
 */
package moe.tlaster.precompose.navigation;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moe.tlaster.precompose.lifecycle.Lifecycle;
import moe.tlaster.precompose.lifecycle.LifecycleOwner;
import moe.tlaster.precompose.lifecycle.LifecycleRegistry;
import moe.tlaster.precompose.navigation.BackStackEntry;
import moe.tlaster.precompose.navigation.QueryString;
import moe.tlaster.precompose.navigation.SwipeProperties;
import moe.tlaster.precompose.navigation.UiClosable;
import moe.tlaster.precompose.navigation.route.GroupRoute;
import moe.tlaster.precompose.navigation.route.GroupRouteKt;
import moe.tlaster.precompose.navigation.route.Route;
import moe.tlaster.precompose.navigation.route.SceneRoute;
import moe.tlaster.precompose.navigation.transition.NavTransition;
import moe.tlaster.precompose.stateholder.SavedStateHolder;
import moe.tlaster.precompose.stateholder.StateHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001Bt\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012#\b\u0002\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0011\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010C\u001a\u00020\u0016J\u0006\u0010D\u001a\u00020\u0016J\u000e\u0010E\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0007J\u0006\u0010F\u001a\u00020\u0016R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0016\u0010%\u001a\u0004\u0018\u00010&8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R)\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010*R\u0016\u00109\u001a\u0004\u0018\u00010:8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001c\u0010=\u001a\u0004\u0018\u00010>X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006G"}, d2={"Lmoe/tlaster/precompose/navigation/BackStackEntry;", "Lmoe/tlaster/precompose/lifecycle/LifecycleOwner;", "id", "", "route", "Lmoe/tlaster/precompose/navigation/route/Route;", "path", "", "pathMap", "", "parentStateHolder", "Lmoe/tlaster/precompose/stateholder/StateHolder;", "parentSavedStateHolder", "Lmoe/tlaster/precompose/stateholder/SavedStateHolder;", "queryString", "Lmoe/tlaster/precompose/navigation/QueryString;", "requestNavigationLock", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "locked", "", "(JLmoe/tlaster/precompose/navigation/route/Route;Ljava/lang/String;Ljava/util/Map;Lmoe/tlaster/precompose/stateholder/StateHolder;Lmoe/tlaster/precompose/stateholder/SavedStateHolder;Lmoe/tlaster/precompose/navigation/QueryString;Lkotlin/jvm/functions/Function1;)V", "_destroyAfterTransition", "getId", "()J", "lifecycle", "Lmoe/tlaster/precompose/lifecycle/Lifecycle;", "getLifecycle", "()Lmoe/tlaster/precompose/lifecycle/Lifecycle;", "lifecycleRegistry", "Lmoe/tlaster/precompose/lifecycle/LifecycleRegistry;", "getLifecycleRegistry", "()Lmoe/tlaster/precompose/lifecycle/LifecycleRegistry;", "lifecycleRegistry$delegate", "Lkotlin/Lazy;", "navTransition", "Lmoe/tlaster/precompose/navigation/transition/NavTransition;", "getNavTransition$precompose", "()Lmoe/tlaster/precompose/navigation/transition/NavTransition;", "getPath", "()Ljava/lang/String;", "getPathMap", "()Ljava/util/Map;", "getQueryString", "()Lmoe/tlaster/precompose/navigation/QueryString;", "getRoute", "()Lmoe/tlaster/precompose/navigation/route/Route;", "savedStateHolder", "getSavedStateHolder", "()Lmoe/tlaster/precompose/stateholder/SavedStateHolder;", "stateHolder", "getStateHolder", "()Lmoe/tlaster/precompose/stateholder/StateHolder;", "stateId", "getStateId$precompose", "swipeProperties", "Lmoe/tlaster/precompose/navigation/SwipeProperties;", "getSwipeProperties$precompose", "()Lmoe/tlaster/precompose/navigation/SwipeProperties;", "uiClosable", "Lmoe/tlaster/precompose/navigation/UiClosable;", "getUiClosable$precompose", "()Lmoe/tlaster/precompose/navigation/UiClosable;", "setUiClosable$precompose", "(Lmoe/tlaster/precompose/navigation/UiClosable;)V", "active", "destroy", "hasRoute", "inActive", "precompose"})
@StabilityInferred(parameters=0)
public final class BackStackEntry
implements LifecycleOwner {
    private final long id;
    @NotNull
    private final Route route;
    @NotNull
    private final String path;
    @NotNull
    private final Map<String, String> pathMap;
    @NotNull
    private final StateHolder parentStateHolder;
    @Nullable
    private final QueryString queryString;
    @NotNull
    private final Function1<Boolean, Unit> requestNavigationLock;
    @Nullable
    private UiClosable uiClosable;
    private boolean _destroyAfterTransition;
    @NotNull
    private final String stateId;
    @NotNull
    private final StateHolder stateHolder;
    @NotNull
    private final SavedStateHolder savedStateHolder;
    @NotNull
    private final Lazy lifecycleRegistry$delegate;
    public static final int $stable = 8;

    public BackStackEntry(long id, @NotNull Route route, @NotNull String path, @NotNull Map<String, String> pathMap, @NotNull StateHolder parentStateHolder, @NotNull SavedStateHolder parentSavedStateHolder, @Nullable QueryString queryString, @NotNull Function1<? super Boolean, Unit> requestNavigationLock) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(pathMap, (String)"pathMap");
        Intrinsics.checkNotNullParameter((Object)parentStateHolder, (String)"parentStateHolder");
        Intrinsics.checkNotNullParameter((Object)parentSavedStateHolder, (String)"parentSavedStateHolder");
        Intrinsics.checkNotNullParameter(requestNavigationLock, (String)"requestNavigationLock");
        this.id = id;
        this.route = route;
        this.path = path;
        this.pathMap = pathMap;
        this.parentStateHolder = parentStateHolder;
        this.queryString = queryString;
        this.requestNavigationLock = requestNavigationLock;
        this.stateId = this.id + "-" + this.route.getRoute();
        this.stateHolder = (StateHolder)this.parentStateHolder.getOrPut(this.stateId, stateHolder.1.INSTANCE);
        this.savedStateHolder = parentSavedStateHolder.child(this.stateId);
        this.lifecycleRegistry$delegate = LazyKt.lazy((Function0)lifecycleRegistry.2.INSTANCE);
    }

    public /* synthetic */ BackStackEntry(long l, Route route, String string, Map map2, StateHolder stateHolder2, SavedStateHolder savedStateHolder, QueryString queryString, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            queryString = null;
        }
        if ((n & 0x80) != 0) {
            function1 = 1.INSTANCE;
        }
        this(l, route, string, map2, stateHolder2, savedStateHolder, queryString, (Function1<? super Boolean, Unit>)function1);
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final Route getRoute() {
        return this.route;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> getPathMap() {
        return this.pathMap;
    }

    @Nullable
    public final QueryString getQueryString() {
        return this.queryString;
    }

    @Nullable
    public final UiClosable getUiClosable$precompose() {
        return this.uiClosable;
    }

    public final void setUiClosable$precompose(@Nullable UiClosable uiClosable) {
        this.uiClosable = uiClosable;
    }

    @NotNull
    public final String getStateId$precompose() {
        return this.stateId;
    }

    @NotNull
    public final StateHolder getStateHolder() {
        return this.stateHolder;
    }

    @NotNull
    public final SavedStateHolder getSavedStateHolder() {
        return this.savedStateHolder;
    }

    @Nullable
    public final SwipeProperties getSwipeProperties$precompose() {
        SceneRoute sceneRoute = GroupRouteKt.toSceneRoute(this.route);
        return sceneRoute != null ? sceneRoute.getSwipeProperties() : null;
    }

    @Nullable
    public final NavTransition getNavTransition$precompose() {
        SceneRoute sceneRoute = GroupRouteKt.toSceneRoute(this.route);
        return sceneRoute != null ? sceneRoute.getNavTransition() : null;
    }

    private final LifecycleRegistry getLifecycleRegistry() {
        Lazy lazy = this.lifecycleRegistry$delegate;
        return (LifecycleRegistry)lazy.getValue();
    }

    @Override
    @NotNull
    public Lifecycle getLifecycle() {
        return this.getLifecycleRegistry();
    }

    public final void active() {
        this.getLifecycleRegistry().setCurrentState(Lifecycle.State.Active);
    }

    public final void inActive() {
        this.getLifecycleRegistry().setCurrentState(Lifecycle.State.InActive);
        if (this._destroyAfterTransition) {
            this.destroy();
        }
    }

    public final void destroy() {
        if (this.getLifecycleRegistry().getCurrentState() != Lifecycle.State.InActive) {
            this._destroyAfterTransition = true;
            this.requestNavigationLock.invoke((Object)true);
        } else {
            this.getLifecycleRegistry().setCurrentState(Lifecycle.State.Destroyed);
            this.stateHolder.close();
            this.parentStateHolder.remove(this.stateId);
            this.savedStateHolder.close();
            UiClosable uiClosable = this.uiClosable;
            if (uiClosable != null) {
                uiClosable.close(this.stateId);
            }
            this.requestNavigationLock.invoke((Object)false);
        }
    }

    public final boolean hasRoute(@NotNull String route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        return Intrinsics.areEqual((Object)this.route.getRoute(), (Object)route) || this.route instanceof GroupRoute && ((GroupRoute)this.route).hasRoute(route);
    }
}

