/*
 * Decompiled with CFR 0.152.
 */
package moe.tlaster.precompose.navigation;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import moe.tlaster.precompose.navigation.RouteMatch;
import moe.tlaster.precompose.navigation.RouteMatchResult;
import moe.tlaster.precompose.navigation.RouteParser;
import moe.tlaster.precompose.navigation.route.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmoe/tlaster/precompose/navigation/RouteParser;", "", "()V", "root", "Lmoe/tlaster/precompose/navigation/RouteParser$Node;", "staticPaths", "Ljava/util/LinkedHashMap;", "", "Lmoe/tlaster/precompose/navigation/route/Route;", "Lkotlin/collections/LinkedHashMap;", "baseCatchAll", "pattern", "find", "Lmoe/tlaster/precompose/navigation/RouteMatchResult;", "path", "findInternal", "insert", "", "route", "Companion", "Node", "Segment", "precompose"})
public final class RouteParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Node root = new Node(0, null, '\u0000', '\u0000', null, null, null, 127, null);
    @NotNull
    private final LinkedHashMap<String, Route> staticPaths = new LinkedHashMap();
    private static final int ntStatic = 0;
    private static final int ntRegexp = 1;
    private static final int ntParam = 2;
    private static final int ntCatchAll = 3;
    private static final int NODE_SIZE = 4;
    private static final char ZERO_CHAR = '\u0000';
    @NotNull
    private static final String BASE_CATCH_ALL = "/?*";

    public final void insert(@NotNull String pattern, @NotNull Route route) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Object patternStr = pattern;
        String baseCatchAll = this.baseCatchAll((String)patternStr);
        if (baseCatchAll.length() > 1) {
            this.insert(baseCatchAll, route);
            String string = ((String)patternStr).substring(baseCatchAll.length() + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String tail = string;
            patternStr = baseCatchAll + "/" + tail;
        }
        if (Intrinsics.areEqual((Object)patternStr, (Object)BASE_CATCH_ALL)) {
            patternStr = "/*";
        }
        if (moe.tlaster.precompose.navigation.RouteParser$Companion.pathKeys$default(Companion, (String)patternStr, null, 2, null).isEmpty()) {
            ((Map)this.staticPaths).put(patternStr, route);
        }
        this.root.insertRoute((String)patternStr, route);
    }

    private final String baseCatchAll(String pattern) {
        String string;
        int i = StringsKt.indexOf$default((CharSequence)pattern, (String)BASE_CATCH_ALL, (int)0, (boolean)false, (int)6, null);
        if (i > 0) {
            String string2 = pattern.substring(0, i);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = "";
        }
        return string;
    }

    public final void insert(@NotNull Route route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.insert(route.getRoute(), route);
    }

    @Nullable
    public final RouteMatchResult find(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Route staticRoute = this.staticPaths.get(path);
        if (staticRoute != null) {
            return new RouteMatchResult(staticRoute, null, 2, null);
        }
        return this.findInternal(path);
    }

    private final RouteMatchResult findInternal(String path) {
        RouteMatch result = new RouteMatch();
        Route route = this.root.findRoute(result, path);
        if (route == null) {
            return null;
        }
        Route route2 = route;
        return new RouteMatchResult(route2, (Map<String, String>)result.getPathMap());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0004JP\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00042:\b\u0002\u0010\u0011\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmoe/tlaster/precompose/navigation/RouteParser$Companion;", "", "()V", "BASE_CATCH_ALL", "", "NODE_SIZE", "", "ZERO_CHAR", "", "ntCatchAll", "ntParam", "ntRegexp", "ntStatic", "expandOptionalVariables", "", "pattern", "pathKeys", "onItem", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "key", "value", "", "precompose"})
    @SourceDebugExtension(value={"SMAP\nRouteParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteParser.kt\nmoe/tlaster/precompose/navigation/RouteParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,683:1\n1549#2:684\n1620#2,3:685\n*S KotlinDebug\n*F\n+ 1 RouteParser.kt\nmoe/tlaster/precompose/navigation/RouteParser$Companion\n*L\n671#1:684\n671#1:685,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> pathKeys(@NotNull String pattern, @NotNull Function2<? super String, ? super String, Unit> onItem) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(onItem, (String)"onItem");
            ArrayList<String> result = new ArrayList<String>();
            int start = -1;
            int end = Integer.MAX_VALUE;
            int len = pattern.length();
            int curly = 0;
            for (int i = 0; i < len; ++i) {
                String string;
                String id;
                char ch = pattern.charAt(i);
                if (ch == '{') {
                    if (curly == 0) {
                        start = i + 1;
                        end = Integer.MAX_VALUE;
                    }
                    ++curly;
                    continue;
                }
                if (ch == ':') {
                    end = i;
                    continue;
                }
                if (ch == '}') {
                    String string2;
                    if (--curly != 0) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)pattern.substring(start, Math.min(i, end)), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (end == Integer.MAX_VALUE) {
                        string2 = null;
                    } else {
                        String string3 = pattern.substring(end + 1, i);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    }
                    String it = string2;
                    boolean bl = false;
                    onItem.invoke((Object)id, (Object)it);
                    result.add(id);
                    start = -1;
                    end = Integer.MAX_VALUE;
                    continue;
                }
                if (ch != '*') continue;
                if (i == len - 1) {
                    string = "*";
                } else {
                    String string4 = pattern.substring(i + 1);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                }
                id = string;
                onItem.invoke((Object)id, (Object)"\\.*");
                result.add(id);
                i = len;
            }
            return result;
        }

        public static /* synthetic */ List pathKeys$default(Companion companion, String string, Function2 function2, int n, Object object) {
            if ((n & 2) != 0) {
                function2 = pathKeys.1.INSTANCE;
            }
            return companion.pathKeys(string, (Function2<? super String, ? super String, Unit>)function2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> expandOptionalVariables(@NotNull String pattern) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            if (((CharSequence)pattern).length() == 0 || Intrinsics.areEqual((Object)pattern, (Object)"/")) {
                return CollectionsKt.listOf((Object)"/");
            }
            int len = pattern.length();
            int key = 0;
            LinkedHashMap<Integer, StringBuilder> paths = new LinkedHashMap<Integer, StringBuilder>();
            Function2 pathAppender2 = (Function2)new Function2<Integer, StringBuilder, StringBuilder>(paths){
                final /* synthetic */ LinkedHashMap<Integer, StringBuilder> $paths;
                {
                    this.$paths = $paths;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final StringBuilder invoke(int index, @NotNull StringBuilder segment) {
                    Object object;
                    void key$iv;
                    void $this$getOrPut$iv;
                    Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                    int n = index - 1;
                    for (int i = index; i < n; ++i) {
                        StringBuilder stringBuilder = this.$paths.get(i);
                        if (stringBuilder == null) continue;
                        stringBuilder.append((CharSequence)segment);
                    }
                    Map i = this.$paths;
                    Integer n2 = index;
                    LinkedHashMap<Integer, StringBuilder> linkedHashMap = this.$paths;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        StringBuilder previous;
                        boolean bl = false;
                        StringBuilder value = new StringBuilder();
                        if (index > 0 && !Intrinsics.areEqual((Object)String.valueOf(previous = linkedHashMap.get(index - 1)), (Object)"/")) {
                            value.append((CharSequence)previous);
                        }
                        StringBuilder answer$iv = value;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    return ((StringBuilder)object).append((CharSequence)segment);
                }
            };
            StringBuilder segment = new StringBuilder();
            boolean isLastOptional = false;
            int i = 0;
            while (i < len) {
                char ch = pattern.charAt(i);
                if (ch == '/') {
                    if (((CharSequence)segment).length() > 0) {
                        pathAppender2.invoke((Object)key, (Object)segment);
                        segment.setLength(0);
                    }
                    segment.append(ch);
                    ++i;
                    continue;
                }
                if (ch == '{') {
                    segment.append(ch);
                    int curly = 1;
                    int j = i + 1;
                    while (j < len) {
                        char next = pattern.charAt(j++);
                        segment.append(next);
                        if (next == '{') {
                            ++curly;
                            continue;
                        }
                        if (next != '}') continue;
                        if (--curly != 0) continue;
                    }
                    if (j < len && pattern.charAt(j) == '?') {
                        ++j;
                        isLastOptional = true;
                        if (paths.isEmpty()) {
                            ((Map)paths).put(0, new StringBuilder("/"));
                        }
                        pathAppender2.invoke((Object)(++key), (Object)segment);
                    } else {
                        isLastOptional = false;
                        pathAppender2.invoke((Object)key, (Object)segment);
                    }
                    segment.setLength(0);
                    i = j;
                    continue;
                }
                segment.append(ch);
                ++i;
            }
            if (paths.isEmpty()) {
                return CollectionsKt.listOf((Object)pattern);
            }
            if (((CharSequence)segment).length() > 0) {
                pathAppender2.invoke((Object)key, (Object)segment);
                if (isLastOptional) {
                    ((Map)paths).put(++key, segment);
                }
            }
            Collection<StringBuilder> collection = paths.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable j = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StringBuilder stringBuilder = (StringBuilder)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.toString());
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0005J+\u00105\u001a\b\u0012\u0004\u0012\u00020\u00000\u00112\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00112\u0006\u00103\u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u0002092\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0011\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0000H\u0096\u0002J\t\u0010<\u001a\u00020\u0003H\u00c6\u0003J\t\u0010=\u001a\u00020\u0005H\u00c6\u0003J\t\u0010>\u001a\u00020\u0007H\u00c6\u0003J\t\u0010?\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010A\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010B\u001a\u0004\u0018\u00010\rH\u00c6\u0003JU\u0010C\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010D\u001a\u00020\u00182\b\u0010;\u001a\u0004\u0018\u00010EH\u00d6\u0003J#\u0010F\u001a\u0004\u0018\u00010\u00002\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00000\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010HJ\u0012\u0010I\u001a\u0004\u0018\u00010\u00052\u0006\u0010J\u001a\u00020\u0005H\u0002J\u0018\u0010K\u001a\u0004\u0018\u00010\r2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0005J(\u0010O\u001a\u0004\u0018\u00010\u00002\u0006\u0010P\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010Q\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010R\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010S\u001a\u00020\u00032\u0006\u0010T\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u0005J\u000e\u0010V\u001a\u00020W2\u0006\u0010J\u001a\u00020\u0005J\u001e\u0010X\u001a\u0002092\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0000J\u0019\u0010Y\u001a\u0002092\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011\u00a2\u0006\u0002\u0010ZJ\t\u0010[\u001a\u00020\u0005H\u00d6\u0001RB\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u00110\u0010j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u0011`\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001b\"\u0004\b-\u0010\u001dR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006\\"}, d2={"Lmoe/tlaster/precompose/navigation/RouteParser$Node;", "", "type", "", "prefix", "", "label", "", "tail", "rex", "Lkotlin/text/Regex;", "paramsKey", "route", "Lmoe/tlaster/precompose/navigation/route/Route;", "(ILjava/lang/String;CCLkotlin/text/Regex;Ljava/lang/String;Lmoe/tlaster/precompose/navigation/route/Route;)V", "children", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getChildren", "()Ljava/util/LinkedHashMap;", "setChildren", "(Ljava/util/LinkedHashMap;)V", "isLeaf", "", "()Z", "getLabel", "()C", "setLabel", "(C)V", "getParamsKey", "()Ljava/lang/String;", "setParamsKey", "(Ljava/lang/String;)V", "getPrefix", "setPrefix", "getRex", "()Lkotlin/text/Regex;", "setRex", "(Lkotlin/text/Regex;)V", "getRoute", "()Lmoe/tlaster/precompose/navigation/route/Route;", "setRoute", "(Lmoe/tlaster/precompose/navigation/route/Route;)V", "getTail", "setTail", "getType", "()I", "setType", "(I)V", "addChild", "child", "search", "append", "src", "([Lmoe/tlaster/precompose/navigation/RouteParser$Node;Lmoe/tlaster/precompose/navigation/RouteParser$Node;)[Lmoe/tlaster/precompose/navigation/RouteParser$Node;", "applyRoute", "", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "findEdge", "ns", "([Lmoe/tlaster/precompose/navigation/RouteParser$Node;C)Lmoe/tlaster/precompose/navigation/RouteParser$Node;", "findParamKey", "pattern", "findRoute", "rctx", "Lmoe/tlaster/precompose/navigation/RouteMatch;", "path", "getEdge", "ntyp", "hashCode", "insertRoute", "longestPrefix", "k1", "k2", "patNextSegment", "Lmoe/tlaster/precompose/navigation/RouteParser$Segment;", "replaceChild", "tailSort", "([Lmoe/tlaster/precompose/navigation/RouteParser$Node;)V", "toString", "precompose"})
    @SourceDebugExtension(value={"SMAP\nRouteParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteParser.kt\nmoe/tlaster/precompose/navigation/RouteParser$Node\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,683:1\n1#2:684\n*E\n"})
    private static final class Node
    implements Comparable<Node> {
        private int type;
        @NotNull
        private String prefix;
        private char label;
        private char tail;
        @Nullable
        private Regex rex;
        @Nullable
        private String paramsKey;
        @Nullable
        private Route route;
        @NotNull
        private LinkedHashMap<Integer, Node[]> children;

        public Node(int type, @NotNull String prefix, char label, char tail, @Nullable Regex rex, @Nullable String paramsKey, @Nullable Route route) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            this.type = type;
            this.prefix = prefix;
            this.label = label;
            this.tail = tail;
            this.rex = rex;
            this.paramsKey = paramsKey;
            this.route = route;
            this.children = new LinkedHashMap();
        }

        public /* synthetic */ Node(int n, String string, char c, char c2, Regex regex, String string2, Route route, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                string = "";
            }
            if ((n2 & 4) != 0) {
                c = '\u0000';
            }
            if ((n2 & 8) != 0) {
                c2 = '\u0000';
            }
            if ((n2 & 0x10) != 0) {
                regex = null;
            }
            if ((n2 & 0x20) != 0) {
                string2 = null;
            }
            if ((n2 & 0x40) != 0) {
                route = null;
            }
            this(n, string, c, c2, regex, string2, route);
        }

        public final int getType() {
            return this.type;
        }

        public final void setType(int n) {
            this.type = n;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.prefix = string;
        }

        public final char getLabel() {
            return this.label;
        }

        public final void setLabel(char c) {
            this.label = c;
        }

        public final char getTail() {
            return this.tail;
        }

        public final void setTail(char c) {
            this.tail = c;
        }

        @Nullable
        public final Regex getRex() {
            return this.rex;
        }

        public final void setRex(@Nullable Regex regex) {
            this.rex = regex;
        }

        @Nullable
        public final String getParamsKey() {
            return this.paramsKey;
        }

        public final void setParamsKey(@Nullable String string) {
            this.paramsKey = string;
        }

        @Nullable
        public final Route getRoute() {
            return this.route;
        }

        public final void setRoute(@Nullable Route route) {
            this.route = route;
        }

        @NotNull
        public final LinkedHashMap<Integer, Node[]> getChildren() {
            return this.children;
        }

        public final void setChildren(@NotNull LinkedHashMap<Integer, Node[]> linkedHashMap) {
            Intrinsics.checkNotNullParameter(linkedHashMap, (String)"<set-?>");
            this.children = linkedHashMap;
        }

        @Override
        public int compareTo(@NotNull Node other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.label - other.label;
        }

        @NotNull
        public final Node insertRoute(@NotNull String pattern, @NotNull Route route) {
            int commonPrefix;
            Segment seg;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Node n = this;
            Node parent = null;
            String search = null;
            search = pattern;
            while (true) {
                if (((CharSequence)search).length() == 0) {
                    n.applyRoute(route);
                    return n;
                }
                char label = search.charAt(0);
                seg = label == '{' || label == '*' ? this.patNextSegment(search) : new Segment(0, null, '\u0000', 0, 0, 31, null);
                String prefix = seg.getNodeType() == 1 ? seg.getRexPat() : "";
                parent = n;
                if (n.getEdge(seg.getNodeType(), label, seg.getTail(), prefix) == null) {
                    Node $this$insertRoute_u24lambda_u240 = this;
                    boolean bl = false;
                    char c = seg.getTail();
                    String string = search;
                    Node child = new Node(0, string, label, c, null, null, null, 113, null);
                    Node hn = parent.addChild(child, search);
                    hn.applyRoute(route);
                    return hn;
                }
                if (n.type > 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)search.substring(seg.getEndIndex()), (String)"this as java.lang.String).substring(startIndex)");
                    continue;
                }
                commonPrefix = this.longestPrefix(search, n.prefix);
                if (commonPrefix != n.prefix.length()) break;
                Intrinsics.checkNotNullExpressionValue((Object)search.substring(commonPrefix), (String)"this as java.lang.String).substring(startIndex)");
            }
            String string = search.substring(0, commonPrefix);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Node child = new Node(0, string, '\u0000', '\u0000', null, null, null, 124, null);
            parent.replaceChild(search.charAt(0), seg.getTail(), child);
            n.label = n.prefix.charAt(commonPrefix);
            String string2 = n.prefix.substring(commonPrefix);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            n.prefix = string2;
            child.addChild(n, n.prefix);
            String string3 = search.substring(commonPrefix);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            search = string3;
            if (((CharSequence)search).length() == 0) {
                child.applyRoute(route);
                return child;
            }
            char bl = search.charAt(0);
            String string4 = search;
            Node subchild = new Node(0, string4, bl, '\u0000', null, null, null, 120, null);
            Node hn = child.addChild(subchild, search);
            hn.applyRoute(route);
            return hn;
        }

        @NotNull
        public final Node addChild(@NotNull Node child, @NotNull String search) {
            Node[] nodeArray;
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            Intrinsics.checkNotNullParameter((Object)search, (String)"search");
            String searchStr = search;
            Node n = this;
            Node hn = child;
            Segment seg = this.patNextSegment(searchStr);
            int segTyp = seg.getNodeType();
            int segStartIdx = seg.getStartIndex();
            int segEndIdx = seg.getEndIndex();
            if (segTyp != 0) {
                if (segTyp == 1) {
                    child.prefix = seg.getRexPat();
                    child.rex = new Regex(seg.getRexPat());
                }
                if (segStartIdx == 0) {
                    child.type = segTyp;
                    int n2 = segStartIdx = segTyp == 3 ? -1 : segEndIdx;
                    if (segStartIdx < 0) {
                        segStartIdx = searchStr.length();
                    }
                    child.tail = seg.getTail();
                    child.paramsKey = this.findParamKey(searchStr);
                    if (segStartIdx != searchStr.length()) {
                        String string = searchStr.substring(segStartIdx);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        searchStr = string;
                        char c = searchStr.charAt(0);
                        String string2 = searchStr;
                        nn = new Node(0, string2, c, '\u0000', null, null, null, 120, null);
                        hn = child.addChild(nn, searchStr);
                    }
                } else if (segStartIdx > 0) {
                    child.type = 0;
                    String string = searchStr.substring(0, segStartIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    child.prefix = string;
                    child.rex = null;
                    String string3 = searchStr.substring(segStartIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    searchStr = string3;
                    nn = new Node(segTyp, null, searchStr.charAt(0), seg.getTail(), null, this.findParamKey(searchStr), null, 82, null);
                    hn = child.addChild(nn, searchStr);
                }
            }
            Map map2 = n.children;
            Integer n3 = child.type;
            Node[] it = nodeArray = this.append(n.children.get(child.type), child);
            boolean bl = false;
            this.tailSort(it);
            map2.put(n3, nodeArray);
            return hn;
        }

        private final String findParamKey(String pattern) {
            String startChar = "{";
            String endChar = "}";
            String regexStart = ":";
            if (!StringsKt.startsWith$default((String)pattern, (String)"{", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)pattern, (String)"}", (boolean)false, (int)2, null)) {
                return null;
            }
            int startIndex = StringsKt.indexOf$default((CharSequence)pattern, (String)startChar, (int)0, (boolean)false, (int)6, null);
            int endIndex = StringsKt.indexOf$default((CharSequence)pattern, (String)endChar, (int)0, (boolean)false, (int)6, null);
            int it = StringsKt.indexOf$default((CharSequence)pattern, (String)regexStart, (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            int regexIndex = it == -1 ? pattern.length() : it;
            String string = pattern.substring(Math.min(startIndex + 1, pattern.length() - 1), Math.min(endIndex, regexIndex));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }

        public final void replaceChild(char label, char tail, @NotNull Node child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            Node n = this;
            Node[] nodeArray = n.children.get(child.type);
            if (nodeArray == null) {
                return;
            }
            Node[] children = nodeArray;
            for (int i = 0; i < children.length; ++i) {
                if (children[i].label != label || children[i].tail != tail) continue;
                children[i] = child;
                children[i].label = label;
                children[i].tail = tail;
                return;
            }
            throw new IllegalArgumentException("chi: replacing missing child");
        }

        @Nullable
        public final Node getEdge(int ntyp, char label, char tail, @NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Node n = this;
            Node[] nodeArray = n.children.get(ntyp);
            if (nodeArray == null) {
                return null;
            }
            Node[] nds = nodeArray;
            int i = 0;
            while (i < nds.length) {
                if (nds[i].label == label && nds[i].tail == tail) {
                    if (ntyp == 1 && !Intrinsics.areEqual((Object)nds[i].prefix, (Object)prefix)) {
                        ++i;
                        continue;
                    }
                    return nds[i];
                }
                ++i;
            }
            return null;
        }

        public final void applyRoute(@Nullable Route route) {
            Node n = this;
            n.route = route;
        }

        @Nullable
        public final Route findRoute(@NotNull RouteMatch rctx, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)rctx, (String)"rctx");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            block4: for (int ntyp = 0; ntyp < 4; ++ntyp) {
                Route h;
                Node[] nds = this.children.get(ntyp);
                if (nds == null) continue;
                Node xn = null;
                String xsearch = path;
                char label = ((CharSequence)path).length() > 0 ? path.charAt(0) : (char)'\u0000';
                switch (ntyp) {
                    case 0: {
                        xn = this.findEdge(nds, label);
                        if (xn == null || !StringsKt.startsWith$default((String)xsearch, (String)xn.prefix, (boolean)false, (int)2, null)) continue block4;
                        String string = xsearch.substring(xn.prefix.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        xsearch = string;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (((CharSequence)xsearch).length() == 0) continue block4;
                        int idx = 0;
                        while (idx < nds.length) {
                            Route h2;
                            int p;
                            xn = nds[idx];
                            if (xn.type != 0) {
                                if (xn.paramsKey != null) {
                                    String it;
                                    boolean bl = false;
                                    rctx.getKeys().add(it);
                                }
                            }
                            if ((p = StringsKt.indexOf$default((CharSequence)xsearch, (char)xn.tail, (int)0, (boolean)false, (int)6, null)) < 0) {
                                if (xn.tail != '/') {
                                    ++idx;
                                    continue;
                                }
                                p = xsearch.length();
                            }
                            Regex rex = xn.rex;
                            if (ntyp == 1 && rex != null) {
                                String string = xsearch.substring(0, p);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                if (!rex.matches((CharSequence)string)) {
                                    ++idx;
                                    continue;
                                }
                            } else {
                                String string = xsearch.substring(0, p);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                if (StringsKt.indexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null) != -1) {
                                    ++idx;
                                    continue;
                                }
                            }
                            int prevlen = rctx.getVars().size();
                            String string = xsearch.substring(0, p);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            rctx.value(string);
                            String string2 = xsearch.substring(p);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                            xsearch = string2;
                            if (((CharSequence)xsearch).length() == 0 && xn.isLeaf() && (h2 = xn.route) != null) {
                                rctx.key();
                                return h2;
                            }
                            Route fin = xn.findRoute(rctx, xsearch);
                            if (fin != null) {
                                return fin;
                            }
                            rctx.truncate(prevlen);
                            xsearch = path;
                            ++idx;
                        }
                        break;
                    }
                    default: {
                        if (((CharSequence)xsearch).length() > 0) {
                            rctx.value(xsearch);
                        }
                        xn = nds[0];
                        xsearch = "";
                    }
                }
                if (xn == null) continue;
                if (((CharSequence)xsearch).length() == 0 && xn.isLeaf() && (h = xn.route) != null) {
                    rctx.key();
                    return h;
                }
                Route fin = xn.findRoute(rctx, xsearch);
                if (fin != null) {
                    return fin;
                }
                if (xn.type <= 0) continue;
                rctx.pop();
            }
            return null;
        }

        @Nullable
        public final Node findEdge(@NotNull Node[] ns, char label) {
            Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
            int num = ns.length;
            int idx = 0;
            int i = 0;
            int j = num - 1;
            while (i <= j) {
                idx = i + (j - i) / 2;
                if (Intrinsics.compare((int)label, (int)ns[idx].label) > 0) {
                    i = idx + 1;
                    continue;
                }
                if (Intrinsics.compare((int)label, (int)ns[idx].label) < 0) {
                    j = idx - 1;
                    continue;
                }
                i = num;
            }
            return ns[idx].label != label ? null : ns[idx];
        }

        public final boolean isLeaf() {
            return this.route != null;
        }

        public final int longestPrefix(@NotNull String k1, @NotNull String k2) {
            Intrinsics.checkNotNullParameter((Object)k1, (String)"k1");
            Intrinsics.checkNotNullParameter((Object)k2, (String)"k2");
            int len = Math.min(k1.length(), k2.length());
            for (int i = 0; i < len; ++i) {
                if (k1.charAt(i) == k2.charAt(i)) continue;
                return i;
            }
            return len;
        }

        public final void tailSort(@NotNull Node[] ns) {
            Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
            if (ns.length > 1) {
                ArraysKt.sort((Object[])ns);
                int n = ns.length + -1;
                if (0 <= n) {
                    do {
                        int i = n--;
                        if (ns[i].type <= 0 || ns[i].tail != '/') continue;
                        Node tmp = ns[i];
                        ns[i] = ns[ns.length - 1];
                        ns[ns.length - 1] = tmp;
                        return;
                    } while (0 <= n);
                }
            }
        }

        private final Node[] append(Node[] src, Node child) {
            if (src == null) {
                Node[] nodeArray = new Node[]{child};
                return nodeArray;
            }
            Object[] objectArray = Arrays.copyOf(src, src.length);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, size)");
            Object[] result = objectArray;
            return (Node[])ArraysKt.plus((Object[])result, (Object)child);
        }

        @NotNull
        public final Segment patNextSegment(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            int ps = StringsKt.indexOf$default((CharSequence)pattern, (char)'{', (int)0, (boolean)false, (int)6, null);
            int ws = StringsKt.indexOf$default((CharSequence)pattern, (char)'*', (int)0, (boolean)false, (int)6, null);
            if (ps < 0 && ws < 0) {
                return new Segment(0, "", '\u0000', 0, pattern.length());
            }
            if (!(ps < 0 || ws < 0 || ws >= ps)) {
                boolean $i$a$-require-RouteParser$Node$patNextSegment$32 = false;
                String $i$a$-require-RouteParser$Node$patNextSegment$32 = "chi: wildcard '*' must be the last pattern in a route, otherwise use a '{param}'";
                throw new IllegalArgumentException($i$a$-require-RouteParser$Node$patNextSegment$32.toString());
            }
            char tail = '/';
            if (ps >= 0) {
                int nt = 2;
                int cc = 0;
                int pe = ps;
                String string = pattern.substring(ps);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String range = string;
                int n = range.length();
                for (int i = 0; i < n; ++i) {
                    char c = range.charAt(i);
                    if (c == '{') {
                        ++cc;
                        continue;
                    }
                    if (c != '}' || --cc != 0) continue;
                    pe = ps + i;
                    break;
                }
                if (!(pe != ps)) {
                    boolean $i$a$-require-RouteParser$Node$patNextSegment$42 = false;
                    String $i$a$-require-RouteParser$Node$patNextSegment$42 = "Router: route param closing delimiter '}' is missing";
                    throw new IllegalArgumentException($i$a$-require-RouteParser$Node$patNextSegment$42.toString());
                }
                String string2 = pattern.substring(ps + 1, pe);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String key = string2;
                if (++pe < pattern.length()) {
                    tail = pattern.charAt(pe);
                }
                Object rexpat = "";
                int idx = StringsKt.indexOf$default((CharSequence)key, (char)':', (int)0, (boolean)false, (int)6, null);
                if (idx >= 0) {
                    nt = 1;
                    String string3 = key.substring(idx + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    rexpat = string3;
                }
                if (((CharSequence)rexpat).length() > 0) {
                    if (((String)rexpat).charAt(0) != '^') {
                        rexpat = "^" + (String)rexpat;
                    }
                    if (((String)rexpat).charAt(((String)rexpat).length() - 1) != '$') {
                        rexpat = (String)rexpat + "$";
                    }
                }
                return new Segment(nt, (String)rexpat, tail, ps, pe);
            }
            return new Segment(3, "", '\u0000', ws, pattern.length());
        }

        public final int component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.prefix;
        }

        public final char component3() {
            return this.label;
        }

        public final char component4() {
            return this.tail;
        }

        @Nullable
        public final Regex component5() {
            return this.rex;
        }

        @Nullable
        public final String component6() {
            return this.paramsKey;
        }

        @Nullable
        public final Route component7() {
            return this.route;
        }

        @NotNull
        public final Node copy(int type, @NotNull String prefix, char label, char tail, @Nullable Regex rex, @Nullable String paramsKey, @Nullable Route route) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return new Node(type, prefix, label, tail, rex, paramsKey, route);
        }

        public static /* synthetic */ Node copy$default(Node node, int n, String string, char c, char c2, Regex regex, String string2, Route route, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = node.type;
            }
            if ((n2 & 2) != 0) {
                string = node.prefix;
            }
            if ((n2 & 4) != 0) {
                c = node.label;
            }
            if ((n2 & 8) != 0) {
                c2 = node.tail;
            }
            if ((n2 & 0x10) != 0) {
                regex = node.rex;
            }
            if ((n2 & 0x20) != 0) {
                string2 = node.paramsKey;
            }
            if ((n2 & 0x40) != 0) {
                route = node.route;
            }
            return node.copy(n, string, c, c2, regex, string2, route);
        }

        @NotNull
        public String toString() {
            return "Node(type=" + this.type + ", prefix=" + this.prefix + ", label=" + this.label + ", tail=" + this.tail + ", rex=" + this.rex + ", paramsKey=" + this.paramsKey + ", route=" + this.route + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.type);
            result = result * 31 + this.prefix.hashCode();
            result = result * 31 + Character.hashCode(this.label);
            result = result * 31 + Character.hashCode(this.tail);
            result = result * 31 + (this.rex == null ? 0 : this.rex.hashCode());
            result = result * 31 + (this.paramsKey == null ? 0 : this.paramsKey.hashCode());
            result = result * 31 + (this.route == null ? 0 : this.route.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (this.type != node.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)node.prefix)) {
                return false;
            }
            if (this.label != node.label) {
                return false;
            }
            if (this.tail != node.tail) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rex, (Object)node.rex)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paramsKey, (Object)node.paramsKey)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.route, (Object)node.route);
        }

        public Node() {
            this(0, null, '\u0000', '\u0000', null, null, null, 127, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lmoe/tlaster/precompose/navigation/RouteParser$Segment;", "", "nodeType", "", "rexPat", "", "tail", "", "startIndex", "endIndex", "(ILjava/lang/String;CII)V", "getEndIndex", "()I", "getNodeType", "getRexPat", "()Ljava/lang/String;", "getStartIndex", "getTail", "()C", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "precompose"})
    @StabilityInferred(parameters=0)
    public static final class Segment {
        private final int nodeType;
        @NotNull
        private final String rexPat;
        private final char tail;
        private final int startIndex;
        private final int endIndex;
        public static final int $stable;

        public Segment(int nodeType, @NotNull String rexPat, char tail, int startIndex, int endIndex) {
            Intrinsics.checkNotNullParameter((Object)rexPat, (String)"rexPat");
            this.nodeType = nodeType;
            this.rexPat = rexPat;
            this.tail = tail;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public /* synthetic */ Segment(int n, String string, char c, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                string = "";
            }
            if ((n4 & 4) != 0) {
                c = '\u0000';
            }
            if ((n4 & 8) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x10) != 0) {
                n3 = 0;
            }
            this(n, string, c, n2, n3);
        }

        public final int getNodeType() {
            return this.nodeType;
        }

        @NotNull
        public final String getRexPat() {
            return this.rexPat;
        }

        public final char getTail() {
            return this.tail;
        }

        public final int getStartIndex() {
            return this.startIndex;
        }

        public final int getEndIndex() {
            return this.endIndex;
        }

        public final int component1() {
            return this.nodeType;
        }

        @NotNull
        public final String component2() {
            return this.rexPat;
        }

        public final char component3() {
            return this.tail;
        }

        public final int component4() {
            return this.startIndex;
        }

        public final int component5() {
            return this.endIndex;
        }

        @NotNull
        public final Segment copy(int nodeType, @NotNull String rexPat, char tail, int startIndex, int endIndex) {
            Intrinsics.checkNotNullParameter((Object)rexPat, (String)"rexPat");
            return new Segment(nodeType, rexPat, tail, startIndex, endIndex);
        }

        public static /* synthetic */ Segment copy$default(Segment segment, int n, String string, char c, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = segment.nodeType;
            }
            if ((n4 & 2) != 0) {
                string = segment.rexPat;
            }
            if ((n4 & 4) != 0) {
                c = segment.tail;
            }
            if ((n4 & 8) != 0) {
                n2 = segment.startIndex;
            }
            if ((n4 & 0x10) != 0) {
                n3 = segment.endIndex;
            }
            return segment.copy(n, string, c, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Segment(nodeType=" + this.nodeType + ", rexPat=" + this.rexPat + ", tail=" + this.tail + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.nodeType);
            result = result * 31 + this.rexPat.hashCode();
            result = result * 31 + Character.hashCode(this.tail);
            result = result * 31 + Integer.hashCode(this.startIndex);
            result = result * 31 + Integer.hashCode(this.endIndex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Segment)) {
                return false;
            }
            Segment segment = (Segment)other;
            if (this.nodeType != segment.nodeType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rexPat, (Object)segment.rexPat)) {
                return false;
            }
            if (this.tail != segment.tail) {
                return false;
            }
            if (this.startIndex != segment.startIndex) {
                return false;
            }
            return this.endIndex == segment.endIndex;
        }

        public Segment() {
            this(0, null, '\u0000', 0, 0, 31, null);
        }
    }
}

