/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import nl.cwi.monetdb.jdbc.MonetResultSet;

final class MonetVirtualResultSet
extends MonetResultSet {
    private Object[] results;
    private boolean closed;

    MonetVirtualResultSet(Statement statement, String[] columns, String[] types, int[] jdbcTypes, Object[] results) throws IllegalArgumentException, IOException, SQLException {
        super(statement, columns, types, jdbcTypes, results.length);
        this.results = results;
        this.closed = false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed!", "M1M20");
        }
        if (row < 0) {
            row = this.tupleCount + row + 1;
        }
        if (row < 0) {
            row = 0;
        } else if (row > this.tupleCount + 1) {
            row = this.tupleCount + 1;
        }
        this.curRow = row;
        return row >= 1 && row <= this.tupleCount;
    }

    @Override
    public long getLong(int column) throws SQLException {
        return Long.parseLong(((String[])this.results[0])[0]);
    }

    @Override
    public int getInt(int column) throws SQLException {
        return (int)this.getLong(column);
    }

    @Override
    public String getString(int column) throws SQLException {
        return ((String[])this.results[0])[0];
    }

    @Override
    public Object getObject(int column) throws SQLException {
        return this.getLong(column);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.results = null;
        }
    }
}

