/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.protocol;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Map;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.responses.AbstractDataBlockResponse;
import nl.cwi.monetdb.mcl.responses.AutoCommitResponse;
import nl.cwi.monetdb.mcl.responses.ResultSetResponse;
import nl.cwi.monetdb.mcl.responses.SchemaResponse;
import nl.cwi.monetdb.mcl.responses.UpdateResponse;

public abstract class AbstractProtocol {
    private final SimpleDateFormat monetDate = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat monetTime = new SimpleDateFormat("HH:mm:ss.SSS");
    private final SimpleDateFormat monetTimeTz = new SimpleDateFormat("HH:mm:ss.SSSZ");
    private final SimpleDateFormat monetTimePrinter = new SimpleDateFormat("HH:mm:ss");
    private final SimpleDateFormat monetTimeTzPrinter = new SimpleDateFormat("HH:mm:ssXXX");
    private final SimpleDateFormat monetTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final SimpleDateFormat monetTimestampTz = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    private final SimpleDateFormat monetTimestampPrinter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
    private final SimpleDateFormat monetTimestampTzPrinter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSXXX");
    private final ParsePosition monetParserPosition = new ParsePosition(0);

    public SimpleDateFormat getMonetDate() {
        return this.monetDate;
    }

    public SimpleDateFormat getMonetTime() {
        return this.monetTime;
    }

    public SimpleDateFormat getMonetTimeTz() {
        return this.monetTimeTz;
    }

    public SimpleDateFormat getMonetTimePrinter() {
        return this.monetTimePrinter;
    }

    public SimpleDateFormat getMonetTimeTzPrinter() {
        return this.monetTimeTzPrinter;
    }

    public SimpleDateFormat getMonetTimestamp() {
        return this.monetTimestamp;
    }

    public SimpleDateFormat getMonetTimestampTz() {
        return this.monetTimestampTz;
    }

    public SimpleDateFormat getMonetTimestampPrinter() {
        return this.monetTimestampPrinter;
    }

    public SimpleDateFormat getMonetTimestampTzPrinter() {
        return this.monetTimestampTzPrinter;
    }

    public ParsePosition getMonetParserPosition() {
        return this.monetParserPosition;
    }

    public abstract void waitUntilPrompt() throws IOException;

    public abstract void fetchNextResponseData() throws IOException;

    public abstract int getCurrentServerResponse();

    public abstract int getNextStarterHeader();

    public abstract ResultSetResponse getNextResultSetResponse(MonetConnection var1, MonetConnection.ResponseList var2, int var3, int var4) throws ProtocolException;

    public abstract UpdateResponse getNextUpdateResponse() throws ProtocolException;

    public SchemaResponse getNextSchemaResponse() {
        return new SchemaResponse();
    }

    public abstract AutoCommitResponse getNextAutoCommitResponse() throws ProtocolException;

    public abstract AbstractDataBlockResponse getAnEmptyDataBlockResponse(int var1, int var2, AbstractProtocol var3, int[] var4, String[] var5);

    public abstract AbstractDataBlockResponse getNextDatablockResponse(Map<Integer, ResultSetResponse> var1) throws ProtocolException;

    public abstract int getNextTableHeader(String[] var1, int[] var2, String[] var3, String[] var4) throws ProtocolException;

    public abstract String getRemainingStringLine(int var1);

    public abstract void writeNextQuery(String var1, String var2, String var3) throws IOException;
}

