/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.protocol.oldmapi;

import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.protocol.oldmapi.OldMapiProtocol;

final class OldMapiStartOfHeaderParser {
    private OldMapiStartOfHeaderParser() {
    }

    static int getNextStartHeaderOnOldMapi(OldMapiProtocol protocol) {
        int res;
        switch (protocol.lineBuffer.get()) {
            case '0': {
                res = 0;
                break;
            }
            case '1': {
                res = 1;
                protocol.lineBuffer.get();
                break;
            }
            case '2': {
                res = 2;
                protocol.lineBuffer.get();
                break;
            }
            case '3': {
                res = 3;
                break;
            }
            case '4': {
                res = 4;
                protocol.lineBuffer.get();
                break;
            }
            case '5': {
                res = 5;
                protocol.lineBuffer.get();
                break;
            }
            case '6': {
                res = 6;
                protocol.lineBuffer.get();
                break;
            }
            default: {
                res = 7;
            }
        }
        return res;
    }

    static int getNextResponseDataAsInt(OldMapiProtocol protocol) throws ProtocolException {
        char chr;
        int currentPointer = protocol.lineBuffer.position();
        int limit = protocol.lineBuffer.limit();
        char[] array = protocol.lineBuffer.array();
        if (currentPointer >= limit) {
            throw new ProtocolException("unexpected end of string", currentPointer - 1);
        }
        int tmp = 0;
        boolean positive = true;
        if ((chr = array[currentPointer++]) >= '0' && chr <= '9') {
            tmp = chr - 48;
        } else if (chr == '-') {
            positive = false;
        } else {
            throw new ProtocolException("expected a digit", currentPointer - 1);
        }
        while (currentPointer < limit && (chr = array[currentPointer++]) != ' ') {
            tmp *= 10;
            if (chr >= '0' && chr <= '9') {
                tmp += chr - 48;
                continue;
            }
            throw new ProtocolException("expected a digit", currentPointer - 1);
        }
        protocol.lineBuffer.position(currentPointer);
        return positive ? tmp : -tmp;
    }

    static String getNextResponseDataAsString(OldMapiProtocol protocol) throws ProtocolException {
        char chr;
        int currentPointer = protocol.lineBuffer.position();
        int limit = protocol.lineBuffer.limit();
        char[] array = protocol.lineBuffer.array();
        if (currentPointer >= limit) {
            throw new ProtocolException("unexpected end of string", currentPointer - 1);
        }
        int cnt = 0;
        int mark = currentPointer;
        while (currentPointer < limit && (chr = array[currentPointer++]) != ' ') {
            ++cnt;
        }
        protocol.lineBuffer.position(mark);
        return new String(array, 0, cnt);
    }
}

