/*
 * Decompiled with CFR 0.152.
 */
package monster.nor.prunes.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import monster.nor.prunes.io.PathUtilsKt;
import monster.nor.prunes.logger.LoggerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0018\u0010\b\u001a\u00020\u0001*\u00020\t2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\n\u001a\n\u0010\u000b\u001a\u00020\u0003*\u00020\u0003\u001a \u0010\f\u001a\u0004\u0018\u00010\u0003*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\t*\u00020\u0003\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"temporaryDirectory", "", "rootDir", "Ljava/nio/file/Path;", "closure", "Lkotlin/Function1;", "confirm", "rhs", "fail", "", "Lkotlin/Function0;", "inUuidDirectory", "moveToDir", "Lkotlin/Pair;", "dist", "safeDelete", "search", "glob", "", "prunes"})
public final class DirectoriesKt {
    public static final void temporaryDirectory(@Nullable Path rootDir, @NotNull Function1<? super Path, Unit> closure) {
        Object object;
        Comparable<Path> comparable;
        Object object2;
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        Path path = rootDir;
        if (path == null) {
            object2 = null;
        } else {
            Path it = path;
            boolean bl = false;
            Path path2 = rootDir.resolve(UUID.randomUUID().toString());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"rootDir.resolve(UUID.randomUUID().toString())");
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(this, *attributes)");
            object2 = path3;
        }
        Object object3 = object2;
        if (object3 == null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            comparable = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"createTempDirectory(prefix, *attributes)");
            object = comparable;
        } else {
            object = object3;
        }
        Object dir = object;
        try {
            boolean bl = false;
            closure.invoke(dir);
            object3 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw it;
        }
        Object it = object3;
        boolean bl = false;
        comparable = dir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"dir.toFile()");
        FilesKt.deleteRecursively((File)comparable);
    }

    public static /* synthetic */ void temporaryDirectory$default(Path path, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        DirectoriesKt.temporaryDirectory(path, (Function1<? super Path, Unit>)function1);
    }

    @Nullable
    public static final Path search(@NotNull Path $this$search, @NotNull String glob) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$search, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
            Iterable $this$firstOrNull$iv = PathsKt.listDirectoryEntries((Path)$this$search, (String)glob);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public static final Path inUuidDirectory(@NotNull Path $this$inUuidDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$inUuidDirectory, (String)"<this>");
        Path path = $this$inUuidDirectory.resolve(UUID.randomUUID().toString());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(UUID.randomUUID().toString())");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(this, *attributes)");
        return path2;
    }

    public static final void confirm(@NotNull Path $this$confirm, @NotNull Path rhs) {
        Intrinsics.checkNotNullParameter((Object)$this$confirm, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(rhs, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException(Intrinsics.stringPlus((String)"not found ", (Object)rhs));
        }
        if (Files.size(rhs) != Files.size($this$confirm)) {
            throw new IOException();
        }
    }

    public static final boolean safeDelete(@NotNull Path $this$safeDelete) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$safeDelete, (String)"<this>");
        Object object2 = $this$safeDelete;
        try {
            Path $this$safeDelete_u24lambda_u2d5 = object2;
            boolean bl = false;
            Files.delete($this$safeDelete_u24lambda_u2d5);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Throwable throwable2 = it;
            if (throwable2 instanceof IOException) {
                LoggerKt.getLog($this$safeDelete).error(it.getMessage());
            } else if (throwable2 instanceof SecurityException) {
                LoggerKt.getLog($this$safeDelete).error(it.getMessage());
            }
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.notExists($this$safeDelete, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    public static final void fail(boolean $this$fail, @NotNull Function0<Unit> closure) {
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        if (!$this$fail) {
            closure.invoke();
        }
    }

    @Nullable
    public static final Path moveToDir(@NotNull Pair<? extends Path, ? extends Path> $this$moveToDir, @NotNull Path dist) {
        Object object;
        Intrinsics.checkNotNullParameter($this$moveToDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dist, (String)"dist");
        Object object2 = $this$moveToDir;
        try {
            Object object3;
            Pair<? extends Path, ? extends Path> $this$moveToDir_u24lambda_u2d11 = object2;
            boolean bl = false;
            Path path = ((Path)$this$moveToDir_u24lambda_u2d11.getFirst()).getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"first.fileName");
            Path dir = PathUtilsKt.inCreateDirectory(dist, path);
            boolean bl2 = false;
            Object object4 = $this$moveToDir_u24lambda_u2d11;
            try {
                Pair<? extends Path, ? extends Path> $this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7 = object4;
                boolean bl3 = false;
                Path distFirst = dir.resolve(((Path)$this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7.getFirst()).getFileName());
                Path distSecond = dir.resolve(((Path)$this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7.getSecond()).getFileName());
                Path path2 = (Path)$this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)distFirst, (String)"distFirst");
                Path path3 = distFirst;
                Object object5 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                CopyOption[] copyOptionArray = object5;
                object5 = Files.copy(path2, path3, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"copy(this, target, *options)");
                path2 = (Path)$this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7.getSecond();
                Intrinsics.checkNotNullExpressionValue((Object)distSecond, (String)"distSecond");
                path3 = distSecond;
                object5 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                copyOptionArray = object5;
                object5 = Files.copy(path2, path3, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"copy(this, target, *options)");
                DirectoriesKt.confirm((Path)$this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7.getFirst(), distFirst);
                DirectoriesKt.confirm((Path)$this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7.getSecond(), distSecond);
                object3 = Result.constructor-impl((Object)dir);
            }
            catch (Throwable $this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7) {
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$moveToDir_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d7));
            }
            object4 = object3;
            if (Result.isSuccess-impl(object4)) {
                Path it = (Path)object4;
                boolean bl4 = false;
                DirectoriesKt.fail(DirectoriesKt.safeDelete((Path)$this$moveToDir_u24lambda_u2d11.getFirst()), (Function0<Unit>)((Function0)new Function0<Unit>($this$moveToDir_u24lambda_u2d11){
                    final /* synthetic */ Pair<Path, Path> $this_runCatching;
                    {
                        this.$this_runCatching = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        LoggerKt.getLog(this.$this_runCatching).warn("\u30d5\u30a1\u30a4\u30eb " + this.$this_runCatching.getFirst() + " \u304c\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                    }
                }));
                DirectoriesKt.fail(DirectoriesKt.safeDelete((Path)$this$moveToDir_u24lambda_u2d11.getSecond()), (Function0<Unit>)((Function0)new Function0<Unit>($this$moveToDir_u24lambda_u2d11){
                    final /* synthetic */ Pair<Path, Path> $this_runCatching;
                    {
                        this.$this_runCatching = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        LoggerKt.getLog(this.$this_runCatching).warn("\u30d5\u30a1\u30a4\u30eb " + this.$this_runCatching.getSecond() + " \u304c\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                    }
                }));
            }
            Throwable throwable = Result.exceptionOrNull-impl(object4);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl5 = false;
                LoggerKt.getLog($this$moveToDir_u24lambda_u2d11).warn(it.getMessage());
                LoggerKt.trace(LoggerKt.getLog($this$moveToDir_u24lambda_u2d11), it);
                PathUtilsKt.deleteRecursively(dir);
            }
            object = Result.constructor-impl((Object)((Path)(Result.isFailure-impl(object4) ? null : object4)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            LoggerKt.getLog($this$moveToDir).warn(it.getMessage());
        }
        return (Path)(Result.isFailure-impl(object2) ? null : object2);
    }
}

